/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network.messages;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.network.Message;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class MessageCaloricFluxEmitterSelection
implements Message {
    public static final CustomPacketPayload.Type<MessageCaloricFluxEmitterSelection> TYPE = new CustomPacketPayload.Type(Theurgy.loc("caloric_flux_emitter_selection"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageCaloricFluxEmitterSelection> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, m -> m.blockPos, (StreamCodec)CaloricFluxEmitterSelectedPoint.STREAM_CODEC.apply(ByteBufCodecs.list()), m -> m.selectedPoints, MessageCaloricFluxEmitterSelection::new);
    private final List<CaloricFluxEmitterSelectedPoint> selectedPoints;
    private final BlockPos blockPos;

    public MessageCaloricFluxEmitterSelection(BlockPos blockPos, List<CaloricFluxEmitterSelectedPoint> selectedPoints) {
        this.blockPos = blockPos;
        this.selectedPoints = new ArrayList<CaloricFluxEmitterSelectedPoint>(selectedPoints);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Level level = player.level();
        if (level == null || !level.isLoaded(this.blockPos)) {
            return;
        }
        this.selectedPoints.forEach(point -> point.setLevel(level));
        BlockEntity blockEntity = level.getBlockEntity(this.blockPos);
        if (blockEntity instanceof CaloricFluxEmitterBlockEntity) {
            CaloricFluxEmitterBlockEntity caloricFluxEmitterBlockEntity = (CaloricFluxEmitterBlockEntity)blockEntity;
            caloricFluxEmitterBlockEntity.setSelectedPoints(this.selectedPoints);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

