/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.NiterRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.jetbrains.annotations.NotNull;

public class FermentationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 200;

    public FermentationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "fermentation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeFermentationStarterRecipeForTag((TagKey<Item>)Tags.Items.CROPS);
        this.makeFermentationStarterRecipeForTag((TagKey<Item>)Tags.Items.SEEDS);
        this.makeFermentationStarterRecipeForTag((TagKey<Item>)ItemTags.SAPLINGS);
        this.makeFermentationStarterRecipeForTag((TagKey<Item>)ItemTags.FLOWERS);
        this.makeFermentationStarterRecipeForTag((TagKey<Item>)Tags.Items.EGGS);
        this.makeFermentationStarterRecipeForTag((TagKey<Item>)ItemTags.LOGS);
        this.makeFermentationStarterRecipeForTag((TagKey<Item>)ItemTags.PLANKS);
        this.makeRecipesForCropTag(ItemTagRegistry.FERMENTATION_STARTERS);
        this.makeRecipesForCropTag(ItemTagRegistry.SUGARS);
        this.makeRecipesForCropTag((TagKey<Item>)Tags.Items.CROPS);
        this.makeRecipesForCropTag((TagKey<Item>)Tags.Items.SEEDS);
        this.makeRecipesForCropTag((TagKey<Item>)ItemTags.SAPLINGS);
        this.makeRecipesForCropTag((TagKey<Item>)ItemTags.FLOWERS);
        this.makeRecipesForCropTag((TagKey<Item>)Tags.Items.EGGS);
        this.makeRecipesForCropTag((TagKey<Item>)ItemTags.LOGS);
        this.makeRecipesForCropTag((TagKey<Item>)ItemTags.PLANKS);
    }

    public void makeFermentationStarterRecipeForTag(TagKey<Item> cropTag) {
        Builder recipe = (Builder)new Builder(new ItemStack((ItemLike)ItemRegistry.FERMENTATION_STARTER.get(), 20)).fluid((Fluid)FluidRegistry.SAL_AMMONIAC.get(), 100).ingredients(cropTag).ingredients(ItemTagRegistry.SUGARS).time(200);
        this.makeRecipe("_from_" + this.name(cropTag), recipe);
    }

    public void makeRecipesForCropTag(TagKey<Item> cropTag) {
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.EARTHEN_MATTERS_ABUNDANT).fluid((Fluid)Fluids.WATER, 125).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS_ABUNDANT).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.EARTHEN_MATTERS_COMMON).fluid((Fluid)Fluids.WATER, 250).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS_COMMON).ingredients(cropTag).time(200));
        this.makeRecipe((Fluid)Fluids.WATER, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_ABUNDANT, cropTag), (Item)NiterRegistry.GEMS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_COMMON, cropTag), (Item)NiterRegistry.GEMS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_RARE, cropTag), (Item)NiterRegistry.GEMS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_PRECIOUS, cropTag), (Item)NiterRegistry.GEMS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_ABUNDANT, cropTag), (Item)NiterRegistry.METALS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_COMMON, cropTag), (Item)NiterRegistry.METALS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_RARE, cropTag), (Item)NiterRegistry.METALS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_PRECIOUS, cropTag), (Item)NiterRegistry.METALS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_ABUNDANT, cropTag), (Item)NiterRegistry.OTHER_MINERALS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_COMMON, cropTag), (Item)NiterRegistry.OTHER_MINERALS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_RARE, cropTag), (Item)NiterRegistry.OTHER_MINERALS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_PRECIOUS, cropTag), (Item)NiterRegistry.OTHER_MINERALS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.LOGS_ABUNDANT).fluid((Fluid)Fluids.WATER, 125).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_LOGS_ABUNDANT).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.CROPS_ABUNDANT).fluid((Fluid)Fluids.WATER, 125).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_CROPS_ABUNDANT).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.ANIMALS_ABUNDANT).fluid((Fluid)Fluids.WATER, 125).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_ABUNDANT).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.ANIMALS_COMMON).fluid((Fluid)Fluids.WATER, 250).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_COMMON).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.ANIMALS_RARE).fluid((Fluid)Fluids.WATER, 500).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_RARE).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_ABUNDANT).fluid((Fluid)Fluids.WATER, 125).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_ABUNDANT).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_COMMON).fluid((Fluid)Fluids.WATER, 250).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_COMMON_FOR_AUTOMATIC_RECIPES).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.SKELETON_SKULL.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_COMMON, 2).fluid((Fluid)Fluids.WATER, 250).ingredients((ItemLike)SulfurRegistry.SKELETON_SKULL.get()).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_RARE).fluid((Fluid)Fluids.WATER, 500).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_RARE_FOR_AUTOMATIC_RECIPES).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.WITHER_SKELETON_SKULL.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_RARE, 2).fluid((Fluid)Fluids.WATER, 500).ingredients((ItemLike)SulfurRegistry.WITHER_SKELETON_SKULL.get()).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.GHAST_TEAR.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_RARE, 2).fluid((Fluid)Fluids.WATER, 500).ingredients((ItemLike)SulfurRegistry.GHAST_TEAR.get()).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.SHULKER_SHELL.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_RARE, 2).fluid((Fluid)Fluids.WATER, 500).ingredients((ItemLike)SulfurRegistry.SHULKER_SHELL.get()).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.ELYTRA.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_RARE, 2).fluid((Fluid)Fluids.WATER, 500).ingredients((ItemLike)SulfurRegistry.ELYTRA.get()).ingredients(cropTag).time(200));
        this.makeRecipe("_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_PRECIOUS).fluid((Fluid)Fluids.WATER, 1000).ingredients(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_PRECIOUS_FOR_AUTOMATIC_RECIPES).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.NETHER_STAR.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_PRECIOUS, 2).fluid((Fluid)Fluids.WATER, 1000).ingredients((ItemLike)SulfurRegistry.NETHER_STAR.get()).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.HEART_OF_THE_SEA.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_PRECIOUS, 2).fluid((Fluid)Fluids.WATER, 1000).ingredients((ItemLike)SulfurRegistry.HEART_OF_THE_SEA.get()).ingredients(cropTag).time(200));
        this.makeRecipe("_from_" + this.name((ItemLike)SulfurRegistry.DRAGON_EGG.get()) + "_using_" + this.name(cropTag), (Builder)new Builder((ItemLike)NiterRegistry.MOBS_PRECIOUS, 4).fluid((Fluid)Fluids.WATER, 1000).ingredients((ItemLike)SulfurRegistry.DRAGON_EGG.get()).ingredients(cropTag).time(200));
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        this.makeRecipe(this.name((ItemLike)result), fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time, String postFix) {
        this.makeRecipe(this.name((ItemLike)result) + postFix, fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(String name, Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        Builder recipe = (Builder)new Builder(new ItemStack((ItemLike)result, resultCount)).fluid(fluid, fluidAmount).time(time);
        ingredients.forEach(recipe::ingredients);
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    protected void makeRecipe(String suffix, Builder recipe) {
        this.recipeConsumer.accept(this.modLoc(this.name(recipe.result()) + suffix), recipe.build());
    }

    @NotNull
    public String getName() {
        return "Fermentation Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        private final ItemStack result;

        protected Builder(ItemLike result) {
            this(result, 1);
        }

        protected Builder(ItemLike result, int count) {
            this(new ItemStack(result, count));
        }

        protected Builder(ItemStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.FERMENTATION);
            this.result(result);
            this.result = result;
            this.time(200);
        }

        public ItemStack result() {
            return this.result;
        }

        public Builder fluid(TagKey<Fluid> tag, int amount) {
            return (Builder)this.sizedFluidIngredient("fluid", tag, amount);
        }

        public Builder fluid(Fluid fluid, int amount) {
            return (Builder)this.sizedFluidIngredient("fluid", fluid, amount);
        }

        public Builder ingredients(ItemLike item) {
            if (!this.recipe.has("ingredients")) {
                this.recipe.add("ingredients", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)Ingredient.of((ItemLike[])new ItemLike[]{item})).getOrThrow());
            return (Builder)this.getThis();
        }

        public Builder ingredients(TagKey<Item> tag) {
            if (!this.recipe.has("ingredients")) {
                this.recipe.add("ingredients", (JsonElement)new JsonArray());
            }
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", tag.location().toString());
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)jsonobject);
            this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tag.location().toString())));
            return (Builder)this.getThis();
        }
    }
}

