/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.logistics;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MercurialWireEntry
extends EntryProvider {
    public MercurialWireEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("wire", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.COPPER_WIRE.get()})).withText(this.context().pageText()));
        this.pageText("Mercurial Wires can connect different parts of your Mercurial Logistics system. Substances will move freely between any blocks connected by wires.\n");
        this.page("recipe", () -> (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/copper_wire")));
        this.page("usage", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Usage");
        this.pageText("Right-click one block, then right-click another block to connect them with the wire.\n\\\n\\\nOnly mercurial logistics blocks, such as inserters, extractors or connection nodes, can be connected with wires.\n");
        this.page("removal", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Removing Wires");
        this.pageText("To remove a wire, break one of the blocks the wire is connected to.\n\\\n\\\nAlternatively, click both blocks connected by the wire with the wire item once more to remove just the one wire.\n");
    }

    protected String entryName() {
        return "Mercurial Wire";
    }

    protected String entryDescription() {
        return "Item-Over-Wire Transport";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.COPPER_WIRE.get()));
    }

    protected String entryId() {
        return "mercurial_wire";
    }
}

