/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe.condition;

import com.klikli_dev.theurgy.integration.kubejs.KubeJsIntegration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public record FluidTagEmptyCondition(TagKey<Fluid> tag) implements ICondition
{
    public static final MapCodec<FluidTagEmptyCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.xmap(loc -> TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)loc), TagKey::location).fieldOf("tag").forGetter(FluidTagEmptyCondition::tag)).apply((Applicative)builder, FluidTagEmptyCondition::new));

    public FluidTagEmptyCondition(String location) {
        this(ResourceLocation.parse((String)location));
    }

    public FluidTagEmptyCondition(String namespace, String path) {
        this(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public FluidTagEmptyCondition(ResourceLocation tag) {
        this((TagKey<Fluid>)TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)tag));
    }

    public boolean test(ICondition.IContext context) {
        if (KubeJsIntegration.get().isLoaded()) {
            return KubeJsIntegration.get().isEmpty(this.tag);
        }
        return context.getTag(this.tag).isEmpty();
    }

    @NotNull
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    @Override
    public String toString() {
        return "fluid_tag_empty(\"" + String.valueOf(this.tag.location()) + "\")";
    }
}

