/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;

public class LiquefactionRecipe
implements Recipe<ItemHandlerWithFluidRecipeInput> {
    public static final int DEFAULT_TIME = 100;
    public static final MapCodec<LiquefactionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)SizedFluidIngredient.NESTED_CODEC.fieldOf("solvent").forGetter(r -> r.solvent), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("time", (Object)100).forGetter(r -> r.time)).apply((Applicative)instance, LiquefactionRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LiquefactionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.ingredient, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, r -> r.solvent, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.INT, r -> r.time, LiquefactionRecipe::new);
    protected final Ingredient ingredient;
    protected final SizedFluidIngredient solvent;
    protected final ItemStack result;
    protected final int time;

    public LiquefactionRecipe(Ingredient pIngredient, SizedFluidIngredient pSolvent, ItemStack pResult, int time) {
        this.ingredient = pIngredient;
        this.solvent = pSolvent;
        this.result = pResult;
        this.time = time;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.LIQUEFACTION.get();
    }

    public boolean matches(@NotNull ItemHandlerWithFluidRecipeInput pContainer, @NotNull Level pLevel) {
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        return this.ingredient.test(pContainer.getItem(0)) && this.solvent.test(fluid);
    }

    @NotNull
    public ItemStack assemble(@NotNull ItemHandlerWithFluidRecipeInput pCraftingContainer, @NotNull HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider pRegistries) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BlockRegistry.LIQUEFACTION_CAULDRON.get());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializerRegistry.LIQUEFACTION.get();
    }

    public int getTime() {
        return this.time;
    }

    public SizedFluidIngredient getSolvent() {
        return this.solvent;
    }

    public int getSolventAmount() {
        return this.solvent.amount();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public static class Serializer
    implements RecipeSerializer<LiquefactionRecipe> {
        @NotNull
        public MapCodec<LiquefactionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, LiquefactionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

