/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.mercurialwand.mode;

import com.klikli_dev.theurgy.content.item.mercurialwand.mode.CycleSelectedDirectionModeRenderHandler;
import com.klikli_dev.theurgy.content.item.mercurialwand.mode.MercurialWandItemMode;
import com.klikli_dev.theurgy.content.item.mode.TargetDirectionSetter;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class CycleSelectedDirectionMode
extends MercurialWandItemMode {
    private final Lazy<CycleSelectedDirectionModeRenderHandler> renderHandler = Lazy.of(() -> new CycleSelectedDirectionModeRenderHandler(this));

    protected CycleSelectedDirectionMode() {
    }

    @Override
    public String descriptionId() {
        return "item.mode.theurgy.mercurial_wand.rotate_selected_direction";
    }

    @Override
    public void appendHUDText(Player pPlayer, HitResult pHitResult, ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents) {
        BlockHitResult blockHitResult;
        BlockEntity blockEntity;
        MutableComponent description = this.description(pStack, pLevel);
        if (pHitResult instanceof BlockHitResult && (blockEntity = pLevel.getBlockEntity((blockHitResult = (BlockHitResult)pHitResult).getBlockPos())) instanceof TargetDirectionSetter) {
            MutableComponent component;
            TargetDirectionSetter directionSettable = (TargetDirectionSetter)blockEntity;
            Direction currentDirection = directionSettable.targetDirection();
            Direction newDirection = this.nextDirection(currentDirection);
            description = component = Component.translatable((String)"item.mode.theurgy.mercurial_wand.rotate_selected_direction.with_target", (Object[])new Object[]{Component.translatable((String)currentDirection.getName()).withStyle(currentDirection != newDirection ? ChatFormatting.YELLOW : ChatFormatting.GREEN), Component.translatable((String)newDirection.getName()).withStyle(ChatFormatting.GREEN)});
        }
        pTooltipComponents.add((Component)description);
    }

    public CycleSelectedDirectionModeRenderHandler renderHandler() {
        return (CycleSelectedDirectionModeRenderHandler)this.renderHandler.get();
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof TargetDirectionSetter) {
            TargetDirectionSetter directionSettable = (TargetDirectionSetter)blockEntity;
            if (!level.isClientSide) {
                Direction currentDirection = directionSettable.targetDirection();
                Direction newDirection = this.nextDirection(currentDirection);
                directionSettable.targetDirection(newDirection);
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.mode.theurgy.mercurial_wand.rotate_selected_direction.success", (Object[])new Object[]{Component.translatable((String)newDirection.getName()).withStyle(ChatFormatting.GREEN)}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    protected Direction nextDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> Direction.NORTH;
            case Direction.NORTH -> Direction.WEST;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.WEST -> Direction.SOUTH;
            case Direction.EAST -> Direction.DOWN;
            case Direction.DOWN -> Direction.UP;
        };
    }

    protected Direction previousDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> Direction.DOWN;
            case Direction.NORTH -> Direction.UP;
            case Direction.SOUTH -> Direction.DOWN;
            case Direction.WEST -> Direction.NORTH;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.DOWN -> Direction.NORTH;
        };
    }
}

