/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.logistics;

import com.klikli_dev.theurgy.content.behaviour.logistics.InsertTarget;
import com.klikli_dev.theurgy.content.behaviour.logistics.InserterNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeMode;
import com.klikli_dev.theurgy.content.behaviour.logistics.distribution.DistributionMode;
import com.klikli_dev.theurgy.content.behaviour.logistics.distribution.Distributor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public abstract class ExtractorNodeBehaviour<T, C>
extends LeafNodeBehaviour<T, C> {
    protected List<InsertTarget<T, C>> insertTargets = new ArrayList<InsertTarget<T, C>>();
    protected List<BlockCapabilityCache<T, C>> extractTargets = new ArrayList<BlockCapabilityCache<T, C>>();
    protected Distributor<T, C> distributor = DistributionMode.createDistributor(DistributionMode.ROUND_ROBIN, this.insertTargets);

    public ExtractorNodeBehaviour(BlockEntity blockEntity, BlockCapability<T, C> capabilityType) {
        super(blockEntity, capabilityType);
    }

    @Override
    public LeafNodeMode mode() {
        return LeafNodeMode.EXTRACT;
    }

    public List<InsertTarget<T, C>> insertTargets() {
        return this.insertTargets;
    }

    public void resetInsertTargets() {
        this.insertTargets.clear();
    }

    public List<BlockCapabilityCache<T, C>> extractTargets() {
        return this.extractTargets;
    }

    public void onLeafNodeAddedToGraph(GlobalPos pos, LeafNodeBehaviour<T, C> leafNode) {
        if (leafNode.mode() != LeafNodeMode.INSERT) {
            return;
        }
        InserterNodeBehaviour<T, C> inserter = leafNode.asInserter();
        List<BlockCapabilityCache<T, C>> targets = inserter.availableTargetCapabilities();
        for (BlockCapabilityCache<T, C> target : targets) {
            if (target == null || !this.isValidInsertTarget(leafNode, target)) continue;
            this.addInsertTarget(inserter, target);
        }
    }

    public void onLeafNodeRemovedFromGraph(GlobalPos pos, LeafNodeBehaviour<T, C> leafNode) {
        if (leafNode.mode() != LeafNodeMode.INSERT) {
            return;
        }
        for (BlockPos target : leafNode.targets()) {
            this.removeInsertTarget((ResourceKey<Level>)leafNode.level().dimension(), target);
        }
    }

    public void onTargetAddedToGraph(GlobalPos pos, BlockCapabilityCache<T, C> capability, LeafNodeBehaviour<T, C> leafNode) {
        if (leafNode.mode() != LeafNodeMode.INSERT) {
            return;
        }
        InserterNodeBehaviour<T, C> inserter = leafNode.asInserter();
        if (this.isValidInsertTarget(leafNode, capability)) {
            this.addInsertTarget(inserter, capability);
        }
    }

    public void onTargetRemovedFromGraph(GlobalPos pos, LeafNodeBehaviour<T, C> leafNode) {
        if (leafNode.mode() != LeafNodeMode.INSERT) {
            return;
        }
        this.removeInsertTarget(pos);
    }

    protected void addInsertTarget(InserterNodeBehaviour<T, C> inserter, BlockCapabilityCache<T, C> capability) {
        InsertTarget<T, C> insertTarget = new InsertTarget<T, C>(inserter, capability);
        if (!this.insertTargets().contains(insertTarget)) {
            this.insertTargets().add(insertTarget);
            this.distributor.onTargetsChanged();
        }
    }

    protected void removeInsertTarget(GlobalPos pos) {
        this.removeInsertTarget((ResourceKey<Level>)pos.dimension(), pos.pos());
    }

    protected void removeInsertTarget(ResourceKey<Level> dimension, BlockPos pos) {
        if (this.insertTargets().removeIf(cached -> cached.capability().level().dimension().equals(dimension) && cached.capability().pos().equals((Object)pos))) {
            this.distributor.onTargetsChanged();
        }
    }

    @Override
    public void onLoad() {
        this.rebuildExtractTargets();
        super.onLoad();
    }

    public void rebuildExtractTargets() {
        this.extractTargets.clear();
        this.extractTargets.addAll(this.buildTargetCapabilities(this.targets()));
    }

    public List<BlockCapabilityCache<T, C>> buildTargetCapabilities(List<BlockPos> targets) {
        ServerLevel serverLevel = (ServerLevel)this.level();
        return targets.stream().map(target -> BlockCapabilityCache.create(this.capabilityType(), (ServerLevel)serverLevel, (BlockPos)target, this.getTargetContext((BlockPos)target))).toList();
    }

    public void tickServer() {
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putByte("distributor", (byte)this.distributor.mode().ordinal());
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        DistributionMode mode = DistributionMode.ROUND_ROBIN;
        if (pTag.contains("distributor")) {
            mode = DistributionMode.values()[pTag.getByte("distributor")];
        }
        this.distributor = DistributionMode.createDistributor(mode, this.insertTargets);
    }

    protected abstract boolean isValidInsertTarget(LeafNodeBehaviour<T, C> var1, BlockCapabilityCache<T, C> var2);
}

