/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.interaction;

import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.crafting.HasCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.interaction.InteractionBehaviour;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class GenericVatInteractionBehaviour<R extends Recipe<?>>
implements InteractionBehaviour {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof HasCraftingBehaviour)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        HasCraftingBehaviour vat = (HasCraftingBehaviour)blockEntity;
        if (!pPlayer.isShiftKeyDown() || !pPlayer.getMainHandItem().isEmpty()) {
            if ((Boolean)pState.getValue((Property)BlockStateProperties.OPEN) != false) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            this.showClosedMessage(pLevel, pPlayer);
            return ItemInteractionResult.FAIL;
        }
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        CraftingBehaviour craftingBehaviour = vat.craftingBehaviour();
        Boolean isOpen = (Boolean)pState.getValue((Property)BlockStateProperties.OPEN);
        if (!isOpen.booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)), 2);
            craftingBehaviour.stopProcessing();
            blockEntity.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        Optional recipe = craftingBehaviour.getRecipe();
        if (recipe.isPresent() && craftingBehaviour.canCraft(recipe.get())) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)), 2);
            return ItemInteractionResult.SUCCESS;
        }
        this.showNoRecipeMessage(pLevel, pPlayer);
        return ItemInteractionResult.FAIL;
    }

    protected abstract void showNoRecipeMessage(Level var1, Player var2);

    protected abstract void showClosedMessage(Level var1, Player var2);
}

