/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record MatterTransmitterData(TeleportDestination destination, Integer destinationId, boolean beamHidden, String name, boolean once, boolean privateAccess, Set<String> players) {
    public static final Codec<MatterTransmitterData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TeleportDestination.CODEC.fieldOf("destination").forGetter(MatterTransmitterData::destination), (App)Codec.INT.optionalFieldOf("destinationId").forGetter(d -> Optional.ofNullable(d.destinationId)), (App)Codec.BOOL.fieldOf("beamHidden").forGetter(MatterTransmitterData::beamHidden), (App)Codec.STRING.optionalFieldOf("name").forGetter(d -> Optional.ofNullable(d.name)), (App)Codec.BOOL.fieldOf("once").forGetter(MatterTransmitterData::once), (App)Codec.BOOL.fieldOf("privateAccess").forGetter(MatterTransmitterData::privateAccess), (App)Codec.list((Codec)Codec.STRING).fieldOf("players").forGetter(d -> new ArrayList<String>(d.players()))).apply((Applicative)instance, (dest, destId, beam, name, once, priv, players) -> new MatterTransmitterData((TeleportDestination)dest, destId.orElse(null), (boolean)beam, name.orElse(null), (boolean)once, (boolean)priv, (Set<String>)new HashSet<String>((Collection<String>)players))));
    public static final StreamCodec<RegistryFriendlyByteBuf, MatterTransmitterData> STREAM_CODEC = CompositeStreamCodec.composite(TeleportDestination.STREAM_CODEC, d -> d.destination, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), d -> Optional.ofNullable(d.destinationId), (StreamCodec)ByteBufCodecs.BOOL, d -> d.beamHidden, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), d -> Optional.ofNullable(d.name), (StreamCodec)ByteBufCodecs.BOOL, d -> d.once, (StreamCodec)ByteBufCodecs.BOOL, d -> d.privateAccess, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), d -> new ArrayList<String>(d.players), (dest, destId, beam, name, once, priv, players) -> new MatterTransmitterData((TeleportDestination)dest, destId.orElse(null), (boolean)beam, name.orElse(null), (boolean)once, (boolean)priv, (Set<String>)new HashSet<String>((Collection<String>)players)));

    public static MatterTransmitterData createDefault() {
        return new MatterTransmitterData(new TeleportDestination(BlockPosTools.INVALID, (ResourceKey<Level>)Level.OVERWORLD), null, false, null, false, false, Collections.emptySet());
    }

    public MatterTransmitterData withDestination(TeleportDestination destination) {
        return new MatterTransmitterData(destination, this.destinationId, this.beamHidden, this.name, this.once, this.privateAccess, this.players);
    }

    public MatterTransmitterData withDestinationId(Integer destinationId) {
        return new MatterTransmitterData(this.destination, destinationId, this.beamHidden, this.name, this.once, this.privateAccess, this.players);
    }

    public MatterTransmitterData withBeamHidden(boolean beamHidden) {
        return new MatterTransmitterData(this.destination, this.destinationId, beamHidden, this.name, this.once, this.privateAccess, this.players);
    }

    public MatterTransmitterData withName(String name) {
        return new MatterTransmitterData(this.destination, this.destinationId, this.beamHidden, name, this.once, this.privateAccess, this.players);
    }

    public MatterTransmitterData withOnce(boolean once) {
        return new MatterTransmitterData(this.destination, this.destinationId, this.beamHidden, this.name, once, this.privateAccess, this.players);
    }

    public MatterTransmitterData withPrivateAccess(boolean privateAccess) {
        return new MatterTransmitterData(this.destination, this.destinationId, this.beamHidden, this.name, this.once, privateAccess, this.players);
    }

    public MatterTransmitterData withPlayers(Set<String> players) {
        return new MatterTransmitterData(this.destination, this.destinationId, this.beamHidden, this.name, this.once, this.privateAccess, players);
    }

    public MatterTransmitterData addPlayer(String player) {
        HashSet<String> newPlayers = new HashSet<String>(this.players);
        newPlayers.add(player);
        return new MatterTransmitterData(this.destination, this.destinationId, this.beamHidden, this.name, this.once, this.privateAccess, newPlayers);
    }

    public MatterTransmitterData removePlayer(String player) {
        HashSet<String> newPlayers = new HashSet<String>(this.players);
        newPlayers.remove(player);
        return new MatterTransmitterData(this.destination, this.destinationId, this.beamHidden, this.name, this.once, this.privateAccess, newPlayers);
    }
}

