/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record RedstoneInformationData(Set<Integer> channels) {
    public static final Codec<RedstoneInformationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("channels").forGetter(data -> new ArrayList<Integer>(data.channels()))).apply((Applicative)instance, channels -> new RedstoneInformationData(Set.copyOf(channels))));
    public static final StreamCodec<RegistryFriendlyByteBuf, RedstoneInformationData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.collection(HashSet::new)), RedstoneInformationData::channels, RedstoneInformationData::new);
    public static final RedstoneInformationData DEFAULT = new RedstoneInformationData(new HashSet<Integer>());

    public boolean hasChannel(int channel) {
        return this.channels.contains(channel);
    }

    public RedstoneInformationData addChannel(int channel) {
        HashSet<Integer> newChannels = new HashSet<Integer>(this.channels);
        newChannels.add(channel);
        return new RedstoneInformationData(newChannels);
    }

    public RedstoneInformationData removeChannel(int channel) {
        HashSet<Integer> newChannels = new HashSet<Integer>(this.channels);
        newChannels.remove(channel);
        return new RedstoneInformationData(newChannels);
    }
}

