/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting;

import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.crafting.ingredient.JetpackTierIngredient;
import com.blakebr0.ironjetpacks.crafting.recipe.JetpackUpgradeRecipe;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class DynamicRecipeManager {
    private static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    @SubscribeEvent
    public void onRecipeManagerLoading(RecipeManagerLoadingEvent event) {
        JetpackRegistry.getInstance().loadJetpacks();
        for (Jetpack jetpack : JetpackRegistry.getInstance().getJetpacks()) {
            RecipeHolder<ShapedRecipe> cell = DynamicRecipeManager.makeCellRecipe(jetpack);
            RecipeHolder<ShapedRecipe> thruster = DynamicRecipeManager.makeThrusterRecipe(jetpack);
            RecipeHolder<ShapedRecipe> capacitor = DynamicRecipeManager.makeCapacitorRecipe(jetpack);
            RecipeHolder<ShapedRecipe> jetpackSelf = DynamicRecipeManager.makeJetpackRecipe(jetpack);
            RecipeHolder<JetpackUpgradeRecipe> jetpackUpgrade = DynamicRecipeManager.makeJetpackUpgradeRecipe(jetpack);
            if (cell != null) {
                event.addRecipe(cell);
            }
            if (thruster != null) {
                event.addRecipe(thruster);
            }
            if (capacitor != null) {
                event.addRecipe(capacitor);
            }
            if (jetpackSelf != null) {
                event.addRecipe(jetpackSelf);
            }
            if (jetpackUpgrade == null) continue;
            event.addRecipe(jetpackUpgrade);
        }
    }

    public static DynamicRecipeManager getInstance() {
        return INSTANCE;
    }

    private static RecipeHolder<ShapedRecipe> makeCellRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CELL_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.EMPTY) {
            return null;
        }
        Ingredient coil = Ingredient.of((ItemLike[])new ItemLike[]{JetpackRegistry.getInstance().getCoilForTier(jetpack.tier)});
        Ingredient redstone = Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE);
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.EMPTY, redstone, Ingredient.EMPTY, material, coil, material, Ingredient.EMPTY, redstone, Ingredient.EMPTY});
        ResourceLocation id = IronJetpacks.resource(jetpack.name + "_cell");
        ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
        ItemStack result = JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack);
        return new RecipeHolder(id, (Recipe)new ShapedRecipe("ironjetpacks:cells", CraftingBookCategory.MISC, pattern, result));
    }

    private static RecipeHolder<ShapedRecipe> makeThrusterRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_THRUSTER_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.EMPTY) {
            return null;
        }
        Ingredient coil = Ingredient.of((ItemLike[])new ItemLike[]{JetpackRegistry.getInstance().getCoilForTier(jetpack.tier)});
        Ingredient cell = DataComponentIngredient.of((boolean)true, (ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack));
        Ingredient furnace = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.FURNACE});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{material, coil, material, coil, cell, coil, material, furnace, material});
        ResourceLocation id = IronJetpacks.resource(jetpack.name + "_thruster");
        ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
        ItemStack result = JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack);
        return new RecipeHolder(id, (Recipe)new ShapedRecipe("ironjetpacks:thrusters", CraftingBookCategory.MISC, pattern, result));
    }

    private static RecipeHolder<ShapedRecipe> makeCapacitorRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CAPACITOR_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.EMPTY) {
            return null;
        }
        Ingredient cell = DataComponentIngredient.of((boolean)true, (ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack));
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{material, cell, material, material, cell, material, material, cell, material});
        ResourceLocation id = IronJetpacks.resource(jetpack.name + "_capacitor");
        ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
        ItemStack result = JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack);
        return new RecipeHolder(id, (Recipe)new ShapedRecipe("ironjetpacks:capacitors", CraftingBookCategory.MISC, pattern, result));
    }

    private static RecipeHolder<ShapedRecipe> makeJetpackRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        if (jetpack.tier != JetpackRegistry.getInstance().getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.EMPTY) {
            return null;
        }
        Ingredient capacitor = DataComponentIngredient.of((boolean)true, (ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack));
        Ingredient thruster = DataComponentIngredient.of((boolean)true, (ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack));
        Ingredient strap = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAP.get()});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{material, capacitor, material, material, strap, material, thruster, Ingredient.EMPTY, thruster});
        ResourceLocation id = IronJetpacks.resource(jetpack.name + "_jetpack");
        ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
        ItemStack result = JetpackUtils.getItemForJetpack(jetpack);
        return new RecipeHolder(id, (Recipe)new ShapedRecipe("ironjetpacks:jetpacks", CraftingBookCategory.EQUIPMENT, pattern, result));
    }

    private static RecipeHolder<JetpackUpgradeRecipe> makeJetpackUpgradeRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        if (jetpack.tier == JetpackRegistry.getInstance().getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.EMPTY) {
            return null;
        }
        Ingredient capacitor = DataComponentIngredient.of((boolean)true, (ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack));
        Ingredient thruster = DataComponentIngredient.of((boolean)true, (ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack));
        Ingredient jetpackTier = JetpackTierIngredient.of(jetpack.tier - 1);
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{material, capacitor, material, material, jetpackTier, material, thruster, Ingredient.EMPTY, thruster});
        ResourceLocation id = IronJetpacks.resource(jetpack.name + "_jetpack");
        ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
        ItemStack result = JetpackUtils.getItemForJetpack(jetpack);
        return new RecipeHolder(id, (Recipe)new JetpackUpgradeRecipe("ironjetpacks:jetpacks", pattern, result, false));
    }
}

