/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.IListOwner;
import carbonconfiglib.gui.widgets.GuiUtils;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class Element
extends ContainerObjectSelectionList.Entry<Element> {
    protected Minecraft mc = Minecraft.getInstance();
    protected Font font;
    protected Component name;
    protected Component unchanged;
    protected Component changed;
    protected IListOwner owner;
    protected int hash;

    public Element(Component name) {
        this.font = this.mc.font;
        this.hash = ((Object)((Object)this)).hashCode();
        this.setName(name);
    }

    public String getName() {
        return this.name.getString();
    }

    public void setName(Component newName) {
        this.name = newName;
        this.unchanged = this.name.copy().withStyle(ChatFormatting.GRAY);
        this.changed = this.name.copy().withStyle(ChatFormatting.ITALIC);
    }

    public void updateValues() {
    }

    public boolean isChanged() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public void init() {
    }

    public void tick() {
    }

    public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
    }

    protected void renderName(GuiGraphics graphics, float x, float y, boolean changed, int width, int height) {
        GuiUtils.drawScrollingString(graphics, this.font, changed ? this.changed : this.unchanged, x, y - 1.0f, width, height, ConfigElement.GuiAlign.LEFT, -1, this.hash);
    }

    protected void renderText(GuiGraphics graphics, Component text, float x, float y, float width, float height, ConfigElement.GuiAlign align, int color) {
        GuiUtils.drawScrollingString(graphics, this.font, text, x, y, width, height, align, -1, this.hash);
    }

    public List<? extends GuiEventListener> children() {
        return ObjectLists.emptyList();
    }

    public List<? extends NarratableEntry> narratables() {
        return ObjectLists.singleton((Object)new NarratableEntry(){

            public NarratableEntry.NarrationPriority narrationPriority() {
                return NarratableEntry.NarrationPriority.HOVERED;
            }

            public void updateNarration(NarrationElementOutput output) {
                output.add(NarratedElementType.TITLE, Element.this.name);
            }
        });
    }
}

