/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.hardenedarmadillos.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.hardenedarmadillos.HardenedArmadillos;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class IngredientModifier
extends LootModifier {
    public static final MapCodec<IngredientModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> IngredientModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Ingredient.CODEC.fieldOf("addition").forGetter(m -> m.addition)).and((App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(m -> Float.valueOf(m.chance))).and((App)Codec.INT.fieldOf("max").orElse((Object)1).forGetter(m -> m.max)).apply((Applicative)inst, IngredientModifier::new));
    private final Ingredient addition;
    private final float chance;
    private final int max;

    public IngredientModifier(LootItemCondition[] conditionsIn, Ingredient addition, float chance, int max) {
        super(conditionsIn);
        this.addition = addition;
        this.chance = chance;
        this.max = max;
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.getRandom().nextFloat() <= this.chance) {
            Arrays.stream(this.addition.getItems()).forEach(itemStack -> {
                ItemStack stack = itemStack.copy();
                stack.setCount(context.getRandom().nextInt(1, this.max + 1));
                generatedLoot.add((Object)stack);
            });
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)HardenedArmadillos.LOOT_MODIFIER_TYPE.get();
    }
}

