/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.filters;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.rftoolsbuilder.modules.shield.filters.AnimalFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.DefaultFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.HostileFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ItemFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;

public interface ShieldFilter<T extends ShieldFilter<?>> {
    public static final int ACTION_PASS = 0;
    public static final int ACTION_SOLID = 1;
    public static final int ACTION_DAMAGE = 2;
    public static final Map<String, MapCodec<? extends ShieldFilter<?>>> CODECS = Map.of("animal", AnimalFilter.CODEC, "default", DefaultFilter.CODEC, "hostile", HostileFilter.CODEC, "item", ItemFilter.CODEC, "player", PlayerFilter.CODEC);
    public static final Map<String, StreamCodec> STREAM_CODECS = Map.of("animal", AnimalFilter.STREAM_CODEC, "default", DefaultFilter.STREAM_CODEC, "hostile", HostileFilter.STREAM_CODEC, "item", ItemFilter.STREAM_CODEC, "player", PlayerFilter.STREAM_CODEC);
    public static final Codec<ShieldFilter<?>> CODEC = Codec.lazyInitialized(() -> Codec.STRING.dispatch("type", ShieldFilter::getFilterName, s -> CODECS.get(s)));
    public static final StreamCodec<FriendlyByteBuf, ShieldFilter<?>> STREAM_CODEC = StreamCodec.of((buf, shieldFilter) -> {
        buf.writeUtf(shieldFilter.getFilterName());
        StreamCodec streamCodec = shieldFilter.getStreamCodec();
        streamCodec.encode(buf, shieldFilter);
    }, buf -> {
        String id = buf.readUtf();
        StreamCodec streamCodec = STREAM_CODECS.get(id);
        return (ShieldFilter)streamCodec.decode(buf);
    });

    public MapCodec<T> getCodec();

    public StreamCodec<FriendlyByteBuf, T> getStreamCodec();

    public boolean match(Entity var1);

    public int getAction();

    public T setAction(int var1);

    public String getFilterName();

    public static class Serializer
    implements ISerializer<ShieldFilter<?>> {
        public Function<RegistryFriendlyByteBuf, ShieldFilter<?>> getDeserializer() {
            return buf -> {
                if (buf.readBoolean()) {
                    return (ShieldFilter)STREAM_CODEC.decode(buf);
                }
                return null;
            };
        }

        public BiConsumer<RegistryFriendlyByteBuf, ShieldFilter<?>> getSerializer() {
            return (buf, info) -> {
                if (info == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    STREAM_CODEC.encode(buf, info);
                }
            };
        }
    }
}

