/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.blocks;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.builder.data.ChamberControllerData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SpaceChamberControllerTileEntity
extends GenericTileEntity {
    private BlockPos minCorner;
    private BlockPos maxCorner;

    public SpaceChamberControllerTileEntity(BlockPos pos, BlockState state) {
        super(BuilderModule.TYPE_SPACE_CHAMBER_CONTROLLER.get(), pos, state);
    }

    public BlockPos getMinCorner() {
        return this.minCorner;
    }

    public BlockPos getMaxCorner() {
        return this.maxCorner;
    }

    public void createChamber(Player player) {
        int i;
        BlockPos pos = this.getBlockPos();
        int x1 = pos.getX();
        int y1 = pos.getY();
        int z1 = pos.getZ();
        int x2 = x1;
        int y2 = y1;
        int z2 = z1;
        for (i = 1; i < (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (x2 == x1) {
                if (this.getLevel().getBlockState(new BlockPos(x1 - i, y1, z1)).getBlock() == BuilderModule.SPACE_CHAMBER.get()) {
                    x2 = x1 - i;
                } else if (this.level.getBlockState(new BlockPos(x1 + i, y1, z1)).getBlock() == BuilderModule.SPACE_CHAMBER.get()) {
                    x2 = x1 + i;
                }
            }
            if (z2 != z1) continue;
            if (this.level.getBlockState(new BlockPos(x1, y1, z1 - i)).getBlock() == BuilderModule.SPACE_CHAMBER.get()) {
                z2 = z1 - i;
                continue;
            }
            if (this.level.getBlockState(new BlockPos(x1, y1, z1 + i)).getBlock() != BuilderModule.SPACE_CHAMBER.get()) continue;
            z2 = z1 + i;
        }
        if (x1 == x2 || z2 == z1) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Not a valid chamber shape!"));
            return;
        }
        if (this.level.getBlockState(new BlockPos(x2, y1, z2)).getBlock() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Not a valid chamber shape!"));
            return;
        }
        for (i = 1; i < (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (this.level.getBlockState(new BlockPos(x1, y1 - i, z1)).getBlock() == BuilderModule.SPACE_CHAMBER.get()) {
                y2 = y1 - i;
                break;
            }
            if (this.level.getBlockState(new BlockPos(x1, y1 + i, z1)).getBlock() != BuilderModule.SPACE_CHAMBER.get()) continue;
            y2 = y1 + i;
            break;
        }
        if (y1 == y2) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Not a valid chamber shape!"));
            return;
        }
        if (this.level.getBlockState(new BlockPos(x2, y2, z2)).getBlock() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Not a valid chamber shape!"));
            return;
        }
        if (this.level.getBlockState(new BlockPos(x1, y2, z2)).getBlock() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Not a valid chamber shape!"));
            return;
        }
        if (this.level.getBlockState(new BlockPos(x2, y2, z1)).getBlock() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Not a valid chamber shape!"));
            return;
        }
        this.minCorner = new BlockPos(Math.min(x1, x2) + 1, Math.min(y1, y2) + 1, Math.min(z1, z2) + 1);
        this.maxCorner = new BlockPos(Math.max(x1, x2) - 1, Math.max(y1, y2) - 1, Math.max(z1, z2) - 1);
        if (this.minCorner.getX() > this.maxCorner.getX() || this.minCorner.getY() > this.maxCorner.getY() || this.minCorner.getZ() > this.maxCorner.getZ()) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "Chamber is too small!"));
            this.minCorner = null;
            this.maxCorner = null;
            return;
        }
        Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.WHITE) + "Chamber succesfully created!"));
        SpaceChamberRepository chamberRepository = SpaceChamberRepository.get(this.level);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = chamberRepository.getOrCreateChannel(this.getChannel());
        chamberChannel.setDimension((ResourceKey<Level>)this.level.dimension());
        chamberChannel.setMinCorner(this.minCorner);
        chamberChannel.setMaxCorner(this.maxCorner);
        chamberRepository.save();
        this.setChanged();
    }

    public int getChannel() {
        return ((ChamberControllerData)this.getData((Supplier)BuilderModule.CHAMBER_DATA)).channel();
    }

    public int getChamberSize() {
        if (this.getChannel() == -1) {
            return -1;
        }
        if (this.minCorner == null) {
            return -1;
        }
        return (this.maxCorner.getX() - this.minCorner.getX()) * (this.maxCorner.getY() - this.minCorner.getY()) * (this.maxCorner.getZ() - this.minCorner.getZ());
    }

    public void setChannel(int channel) {
        ChamberControllerData data = ((ChamberControllerData)this.getData((Supplier)BuilderModule.CHAMBER_DATA)).withChannel(channel);
        this.setData((Supplier)BuilderModule.CHAMBER_DATA, data);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.minCorner = BlockPosTools.read((CompoundTag)tagCompound, (String)"minCorner");
        this.maxCorner = BlockPosTools.read((CompoundTag)tagCompound, (String)"maxCorner");
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"minCorner", (BlockPos)this.minCorner);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"maxCorner", (BlockPos)this.maxCorner);
    }
}

