/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.contraption;

import com.hollingsworth.ars_creo.contraption.ContraptionCaster;
import com.hollingsworth.ars_creo.contraption.ContraptionUtils;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.serialization.Codec;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public interface ITurretBehavior {
    default public void castSpell(MovementContext context, BlockPos pos) {
        boolean hasNearby;
        ServerLevel world = (ServerLevel)context.world;
        Position iposition = this.getDispensePosition(pos, context.state);
        Direction direction = (Direction)context.state.getValue((Property)BasicSpellTurret.FACING);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        fakePlayer.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        SpellCaster spellCaster = (SpellCaster)ANCodecs.decode((Codec)SpellCaster.CODEC.codec(), (Tag)context.blockEntityData.get("spell_caster"));
        Spell spell = spellCaster.getSpell();
        if (!spell.isValid()) {
            return;
        }
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext((Level)world, spell, (LivingEntity)fakePlayer, (IWrappedCaster)new ContraptionCaster(context, context.contraption.entity)));
        if (!(ContraptionUtils.removeSourceFromContraption(context, spell.getCost(), pos) || (hasNearby = SourceUtil.hasSourceNearby((BlockPos)pos, (Level)world, (int)6, (int)spell.getCost())) && SourceUtil.takeSourceMultipleWithParticles((BlockPos)pos, (Level)world, (int)6, (int)spell.getCost()) != null)) {
            return;
        }
        if (resolver.castType instanceof MethodProjectile) {
            spellCaster.playSound(pos, (Level)world, null, spellCaster.getCurrentSound(), SoundSource.BLOCKS);
            this.shootProjectile(world, pos, (SpellResolver)resolver, context.state, context);
        } else if (resolver.castType instanceof MethodTouch) {
            BlockPos touchPos = BlockPos.containing((double)iposition.x(), (double)iposition.y(), (double)iposition.z());
            if (direction == Direction.WEST || direction == Direction.NORTH) {
                touchPos = touchPos.relative(direction);
            }
            if (direction == Direction.DOWN) {
                touchPos = touchPos.below();
            }
            resolver.onCastOnBlock(new BlockHitResult(new Vec3((double)touchPos.getX(), (double)touchPos.getY(), (double)touchPos.getZ()), direction.getOpposite(), new BlockPos(touchPos.getX(), touchPos.getY(), touchPos.getZ()), false));
        }
    }

    default public void shootProjectile(ServerLevel world, BlockPos pos, SpellResolver resolver, BlockState state, MovementContext context) {
        Vec3 facingVec = Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)BasicSpellTurret.FACING)).getNormal());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        facingVec.normalize();
        Vec3 effectiveMovementVec = facingVec.scale(0.5).add(context.motion);
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)world);
        fakePlayer.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
        spell.setOwner((Entity)fakePlayer);
        double x = (double)pos.getX() + facingVec.x * 0.7 + 0.5;
        double y = (double)pos.getY() + facingVec.y * 0.7 + 0.5;
        double z = (double)pos.getZ() + facingVec.z * 0.7 + 0.5;
        spell.setPos(x, y, z);
        spell.shoot(effectiveMovementVec.x, effectiveMovementVec.y, effectiveMovementVec.z, 0.4f, 0.0f);
        world.addFreshEntity((Entity)spell);
    }

    default public Direction getClosestFacingDirection(Vec3 exactFacing) {
        return Direction.getNearest((double)exactFacing.x, (double)exactFacing.y, (double)exactFacing.z);
    }

    default public Position getDispensePosition(BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)BasicSpellTurret.FACING);
        double d0 = (double)pos.getX() + 0.5 * (double)direction.getStepX();
        double d1 = (double)pos.getY() + 0.5 * (double)direction.getStepY();
        double d2 = (double)pos.getZ() + 0.5 * (double)direction.getStepZ();
        return new Vec3(d0, d1, d2);
    }
}

