/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.outfitted.ReversiblePoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class TransitionTrackBlock
extends ReversiblePoweredOutfittedTrackBlock {
    private static final double BOOST_AMOUNT = 0.04;
    private static final double SLOW_FACTOR = 0.65;
    private static final double BOOST_THRESHOLD = 0.01;
    private static final double START_BOOST = 0.02;

    public TransitionTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos pos) {
        return 16;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, pos, cart);
        boolean reversed = TransitionTrackBlock.isReversed(blockState);
        RailShape railShape = TransitionTrackBlock.getRailShapeRaw(blockState);
        if (!TransitionTrackBlock.isPowered(blockState)) {
            return;
        }
        Vec3 deltaMovement = cart.getDeltaMovement();
        double speed = MinecartUtil.getCartSpeedUncapped(deltaMovement);
        if (speed <= 0.01) {
            MinecartUtil.startBoost(cart, pos, railShape, 0.02);
            return;
        }
        boolean highSpeed = RollingStock.getOrThrow(cart).isHighSpeed();
        if (RailShapeUtil.isNorthSouth(railShape)) {
            if (reversed ^ deltaMovement.z() < 0.0) {
                TransitionTrackBlock.boostCartSpeed(cart, speed);
            } else {
                TransitionTrackBlock.slowOrNormalCartSpeed(cart, highSpeed);
            }
        } else if (!reversed ^ deltaMovement.x() < 0.0) {
            TransitionTrackBlock.boostCartSpeed(cart, speed);
        } else {
            TransitionTrackBlock.slowOrNormalCartSpeed(cart, highSpeed);
        }
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        return level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)REVERSED, (Comparable)Boolean.valueOf((Boolean)blockState.getValue((Property)REVERSED) == false)));
    }

    private static void boostCartSpeed(AbstractMinecart cart, double currentSpeed) {
        Vec3 motion = cart.getDeltaMovement();
        cart.setDeltaMovement(motion.add(motion.x() / currentSpeed * 0.04, 0.0, motion.z() / currentSpeed * 0.04));
    }

    private static void slowCartSpeed(AbstractMinecart cart) {
        if (cart instanceof Locomotive) {
            Locomotive locomotive = (Locomotive)cart;
            locomotive.forceIdle(20);
        }
        cart.setDeltaMovement(cart.getDeltaMovement().multiply(0.65, 1.0, 0.65));
    }

    private static void slowOrNormalCartSpeed(AbstractMinecart cart, boolean highSpeed) {
        if (highSpeed) {
            TransitionTrackBlock.slowCartSpeed(cart);
        } else {
            TransitionTrackBlock.normalCartSpeed(cart);
        }
    }

    private static void normalCartSpeed(AbstractMinecart cart) {
        Vec3 deltaMovement = cart.getDeltaMovement();
        if (Math.abs(deltaMovement.x()) > 0.01) {
            cart.setDeltaMovement(Math.copySign((double)0.3f, deltaMovement.x()), deltaMovement.y(), deltaMovement.z());
        }
        if (Math.abs(deltaMovement.z()) > 0.0) {
            cart.setDeltaMovement(deltaMovement.x(), deltaMovement.y(), Math.copySign((double)0.3f, deltaMovement.z()));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.TRANSITION_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).withStyle(ChatFormatting.RED));
    }
}

