/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.item.Crowbar;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.client.ScreenFactories;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EmbarkingTrackBlock
extends PoweredOutfittedTrackBlock {
    public static final short TELEPORT_PARTICLES = 64;
    public static final int MIN_RADIUS = 1;
    public static final int MAX_RADIUS = 5;
    public static final Set<EntityType<?>> excludedEntities = new HashSet();
    public static final IntegerProperty RADIUS;

    public EmbarkingTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{RADIUS});
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue((Property)RADIUS, (Comparable)Integer.valueOf(2));
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack) {
        if (level.isClientSide()) {
            ScreenFactories.openEmbarkingTrackScreen(blockState, blockPos);
        }
        return true;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos blockPos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, blockPos, cart);
        RollingStock extension = RollingStock.getOrThrow(cart);
        if (EmbarkingTrackBlock.isPowered(blockState) && cart.canBeRidden() && !cart.isVehicle() && extension.isMountable()) {
            int radius = EmbarkingTrackBlock.getRadius(blockState);
            AABB box = BoxBuilder.create().at(blockPos).build();
            List entities = level.getEntitiesOfClass(LivingEntity.class, box = box.inflate((double)radius, (double)radius, (double)radius));
            if (!entities.isEmpty()) {
                LivingEntity entity = (LivingEntity)entities.get(level.getRandom().nextInt(entities.size()));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.isCrouching()) {
                        return;
                    }
                    ItemStack current = player.getMainHandItem();
                    if (!current.isEmpty() && current.getItem() instanceof Crowbar) {
                        return;
                    }
                } else {
                    Slime slime;
                    if (excludedEntities.contains(entity.getType()) || entity instanceof WaterAnimal) {
                        return;
                    }
                    if (entity instanceof Slime && (slime = (Slime)entity).getSize() >= 100) {
                        return;
                    }
                }
                if (!entity.isPassenger()) {
                    EmbarkingTrackBlock.teleportEffect((Entity)entity, cart.position());
                    entity.startRiding((Entity)cart);
                }
            }
        }
    }

    private static void teleportEffect(Entity entity, Vec3 destination) {
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        RandomSource random = level.getRandom();
        Vec3 start = entity.position();
        for (int i = 0; i < 64; ++i) {
            double travel = (double)i / 63.0;
            float vX = (random.nextFloat() - 0.5f) * 0.2f;
            float vY = (random.nextFloat() - 0.5f) * 0.2f;
            float vZ = (random.nextFloat() - 0.5f) * 0.2f;
            double pX = start.x + (destination.x - start.x) * travel + (random.nextDouble() - 0.5) * 2.0;
            double pY = start.y + (destination.y - start.y) * travel + (random.nextDouble() - 0.5) * 2.0;
            double pZ = start.z + (destination.z - start.z) * travel + (random.nextDouble() - 0.5) * 2.0;
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, pX, pY, pZ, (double)vX, (double)vY, (double)vZ);
        }
        level.playSound(null, entity, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 0.25f, 1.0f);
    }

    public static int getRadius(BlockState blockState) {
        return (Integer)blockState.getValue((Property)RADIUS);
    }

    public static BlockState setRadius(BlockState blockState, int radius) {
        return (BlockState)blockState.setValue((Property)RADIUS, (Comparable)Integer.valueOf(Mth.clamp((int)radius, (int)1, (int)5)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.EMBARKING_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_RANGE).withStyle(ChatFormatting.BLUE));
        lines.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).withStyle(ChatFormatting.RED));
    }

    static {
        excludedEntities.add(EntityType.IRON_GOLEM);
        excludedEntities.add(EntityType.ENDER_DRAGON);
        excludedEntities.add(EntityType.WITHER);
        excludedEntities.add(EntityType.BLAZE);
        excludedEntities.add(EntityType.MAGMA_CUBE);
        excludedEntities.add(EntityType.SQUID);
        excludedEntities.add(EntityType.BAT);
        RADIUS = IntegerProperty.create((String)"radius", (int)1, (int)5);
    }
}

