/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import com.mojang.serialization.MapCodec;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.BlockSignalBlockEntity;
import mods.railcraft.world.level.block.signal.SingleSignalBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockSignalBlock
extends SingleSignalBlock
implements JeiSearchable {
    private static final MapCodec<BlockSignalBlock> CODEC = BlockSignalBlock.simpleCodec(BlockSignalBlock::new);

    public BlockSignalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends SingleSignalBlock> codec() {
        return CODEC;
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean moved) {
        if (!blockState.is(newState.getBlock())) {
            level.getBlockEntity(blockPos, (BlockEntityType)RailcraftBlockEntityTypes.BLOCK_SIGNAL.get()).ifPresent(BlockSignalBlockEntity::blockRemoved);
        }
        super.onRemove(blockState, level, blockPos, newState, moved);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockSignalBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return BlockSignalBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.BLOCK_SIGNAL.get()), (BlockEntityTicker)(level.isClientSide() ? BlockSignalBlockEntity::clientTick : BlockSignalBlockEntity::serverTick));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)Translations.Tips.BLOCK_SIGNAL).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.AERIAL_LINKAGES).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)Translations.Tips.SIGNAL_BLOCKS, (Object[])new Object[]{1})).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)Translations.Tips.CONTROLLERS, (Object[])new Object[]{1})).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.RELEVANT_TOOLS).withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)Translations.Tips.SIGNAL_SURVEYOR)).withStyle(ChatFormatting.RED));
    }

    @Override
    public Component jeiDescription() {
        return Component.translatable((String)Translations.Jei.BLOCK_SIGNAL);
    }
}

