/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import com.mojang.authlib.GameProfile;
import mods.railcraft.api.core.Lockable;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class LockableTrackBlockEntity
extends RailcraftBlockEntity
implements Lockable {
    private LockableSwitchTrackActuatorBlockEntity.Lock lock = LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED;

    public LockableTrackBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public LockableSwitchTrackActuatorBlockEntity.Lock getLock() {
        return this.lock;
    }

    public void setLock(@Nullable GameProfile gameProfile) {
        this.lock = gameProfile == null ? LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED : LockableSwitchTrackActuatorBlockEntity.Lock.LOCKED;
        this.setOwner(gameProfile);
    }

    @Override
    public boolean isLocked() {
        return this.lock == LockableSwitchTrackActuatorBlockEntity.Lock.LOCKED;
    }

    @Override
    public boolean canAccess(GameProfile gameProfile) {
        return !this.isLocked() || this.isOwnerOrOperator(gameProfile);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("lock", this.lock.getSerializedName());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.lock = LockableSwitchTrackActuatorBlockEntity.Lock.fromName(tag.getString("lock"));
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.lock);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.lock = (LockableSwitchTrackActuatorBlockEntity.Lock)data.readEnum(LockableSwitchTrackActuatorBlockEntity.Lock.class);
    }
}

