/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mods.railcraft.network.to_client.OpenLogBookScreen;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class LogBookBlockEntity
extends RailcraftBlockEntity {
    private static final float SEARCH_RADIUS = 16.0f;
    private static final int BOOK_LINES_PER_PAGE = 13;
    private final Multimap<LocalDate, String> log = HashMultimap.create();
    private int clock = 0;

    public LogBookBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LOGBOOK.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, LogBookBlockEntity blockEntity) {
        LocalDate date;
        boolean isChanged;
        List<Player> players;
        if (++blockEntity.clock % 32 == 0 && !(players = EntitySearcher.find(Player.class).at(blockPos).inflateHorizontally(16.0).list(level)).isEmpty() && (isChanged = blockEntity.log.putAll((Object)(date = LocalDate.now()), players.stream().map(Player::getGameProfile).map(GameProfile::getName).toList()))) {
            blockEntity.setChanged();
        }
    }

    public static CompoundTag convertLogToTag(Multimap<LocalDate, String> log) {
        CompoundTag tag = new CompoundTag();
        LocalDate monthAgo = LocalDate.now().minusMonths(1L);
        ListTag logList = new ListTag();
        for (Map.Entry entry : log.asMap().entrySet()) {
            if (((LocalDate)entry.getKey()).isBefore(monthAgo)) continue;
            CompoundTag dateEntry = new CompoundTag();
            ListTag players = new ListTag();
            for (String player : (Collection)entry.getValue()) {
                CompoundTag playerTag = new CompoundTag();
                playerTag.putString("player", player);
                players.add((Object)playerTag);
            }
            dateEntry.putString("date", ((LocalDate)entry.getKey()).toString());
            dateEntry.put("players", (Tag)players);
            logList.add((Object)dateEntry);
        }
        tag.put("entries", (Tag)logList);
        return tag;
    }

    public static Multimap<LocalDate, String> convertLogFromTag(CompoundTag tag) {
        HashMultimap log = HashMultimap.create();
        LocalDate monthAgo = LocalDate.now().minusMonths(1L);
        ListTag logList = tag.getList("entries", 10);
        for (int i = 0; i < logList.size(); ++i) {
            CompoundTag compound = logList.getCompound(i);
            LocalDate date = LocalDate.parse(compound.getString("date"));
            try {
                if (date.isBefore(monthAgo)) continue;
                ListTag playerList = compound.getList("players", 10);
                HashSet<String> players = new HashSet<String>();
                for (int j = 0; j < playerList.size(); ++j) {
                    CompoundTag playerCompound = playerList.getCompound(i);
                    players.add(playerCompound.getString("player"));
                }
                log.putAll((Object)date, players);
                continue;
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return log;
    }

    public void use(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenLogBookScreen(LogBookBlockEntity.getPages(this.log)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static List<List<String>> getPages(Multimap<LocalDate, String> log) {
        ArrayList<List<String>> pages = new ArrayList<List<String>>();
        ArrayList days = new ArrayList(log.keySet());
        days.sort(Comparator.reverseOrder());
        for (LocalDate day : days) {
            List<String> page = LogBookBlockEntity.makePage(pages, day);
            for (String profile : log.get((Object)day)) {
                if (page.size() > 13) {
                    page = LogBookBlockEntity.makePage(pages, day);
                }
                page.add(profile);
            }
        }
        return pages;
    }

    private static List<String> makePage(List<List<String>> pages, LocalDate date) {
        LinkedList<String> page = new LinkedList<String>();
        page.add(date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)));
        page.add(StringUtils.repeat((char)'-', (int)34));
        pages.add(page);
        return page;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("log", (Tag)LogBookBlockEntity.convertLogToTag(this.log));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.log.clear();
        this.log.putAll(LogBookBlockEntity.convertLogFromTag(tag.getCompound("log")));
    }
}

