/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class FirestoneBlock
extends Block {
    public FirestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(blockState, level, pos, random);
        BlockPos start = new BlockPos(pos.getX() - 10 + random.nextInt(20), pos.getY(), pos.getZ() - 10 + random.nextInt(20));
        level.playSound(null, start, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f);
        this.spawnBurningFaceParticles(level, pos, random);
    }

    private void spawnBurningFaceParticles(Level level, BlockPos pos, RandomSource random) {
        double pixel = 0.0625;
        BlockState state = level.getBlockState(pos);
        for (Direction facing : Direction.values()) {
            double positiveAxis;
            if (!Block.shouldRenderFace((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)facing, (BlockPos)pos.relative(facing))) continue;
            double px = pos.getX();
            double py = pos.getY();
            double pz = pos.getZ();
            double d = positiveAxis = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 : 0.0;
            px = facing.getAxis() == Direction.Axis.X ? (px += pixel * (double)facing.getStepX() + positiveAxis) : (px += (double)random.nextFloat());
            py = facing.getAxis() == Direction.Axis.Y ? (py += pixel * (double)facing.getStepY() + positiveAxis) : (py += (double)random.nextFloat());
            pz = facing.getAxis() == Direction.Axis.Z ? (pz += pixel * (double)facing.getStepZ() + positiveAxis) : (pz += (double)random.nextFloat());
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, px, py, pz, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, px, py, pz, 0.0, 0.0, 0.0);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity livingEntity;
        Holder.Reference enchantment = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FROST_WALKER);
        if (entity instanceof LivingEntity && EnchantmentHelper.getEnchantmentLevel((Holder)enchantment, (LivingEntity)(livingEntity = (LivingEntity)entity)) == 0) {
            entity.hurt(level.damageSources().hotFloor(), 1.5f);
        }
        super.stepOn(level, pos, state, entity);
    }
}

