/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.providers;

import java.util.concurrent.CompletableFuture;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.RollingRecipeBuilder;
import mods.railcraft.data.recipes.patterns.RollingRecipePattern;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class RollingRecipeProvider
extends RecipeProvider {
    private RollingRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
    }

    public static void genRecipes(RecipeOutput recipeOutput) {
        RollingRecipeProvider.misc(recipeOutput);
        RollingRecipeProvider.buildChargeSpool(recipeOutput);
        RollingRecipeProvider.buildTrackParts(recipeOutput);
        RollingRecipeProvider.buildRebars(recipeOutput);
        RollingRecipeProvider.buildElectrodes(recipeOutput);
        RollingRecipeProvider.buildRails(recipeOutput);
        RollingRecipeProvider.buildPlates(recipeOutput);
    }

    private static void misc(RecipeOutput recipeOutput) {
        RollingRecipePattern.hForm(recipeOutput, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.POST.variantFor(DyeColor.BLACK).get(), 16);
        RollingRecipePattern.diagonalLine(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_PLATE), (ItemLike)RailcraftItems.TURBINE_BLADE.get(), 1, "steel_turbine_blade");
        RollingRecipePattern.diagonalLine(recipeOutput, Ingredient.of(RailcraftTags.Items.NICKEL_PLATE), (ItemLike)RailcraftItems.TURBINE_BLADE.get(), 1, "nickel_turbine_blade");
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.BRONZE_PLATE), (ItemLike)RailcraftItems.BUSHING_GEAR.get(), 4, "_bronze");
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.BRASS_PLATE), (ItemLike)RailcraftItems.BUSHING_GEAR.get(), 4, "_brass");
    }

    private static void buildChargeSpool(RecipeOutput recipeOutput) {
        RollingRecipeBuilder.rolled((ItemLike)RailcraftItems.CHARGE_SPOOL_LARGE.get()).pattern("a").define(Character.valueOf('a'), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).save(recipeOutput);
        RollingRecipeBuilder.rolled((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()).pattern("a").define(Character.valueOf('a'), (TagKey<Item>)Tags.Items.INGOTS_COPPER).save(recipeOutput);
    }

    private static void buildTrackParts(RecipeOutput recipeOutput) {
        Item trackParts = (Item)RailcraftItems.TRACK_PARTS.get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)trackParts).getPath();
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("aa ").pattern("a  ").define(Character.valueOf('a'), RailcraftTags.Items.BRONZE_NUGGET).save(recipeOutput, RailcraftConstants.rl(name + "_bronze_nugget"));
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("aa").define(Character.valueOf('a'), (TagKey<Item>)Tags.Items.NUGGETS_IRON).save(recipeOutput, RailcraftConstants.rl(name + "_iron_nugget"));
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_NUGGET).save(recipeOutput, RailcraftConstants.rl(name + "_steel_nugget"));
    }

    private static void buildRebars(RecipeOutput recipeOutput) {
        RollingRecipePattern.diagonalLine(recipeOutput, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.REBAR.get(), 4, "rebar_iron");
        RollingRecipePattern.diagonalLine(recipeOutput, Ingredient.of(RailcraftTags.Items.BRONZE_INGOT), (ItemLike)RailcraftItems.REBAR.get(), 4, "rebar_bronze");
        RollingRecipePattern.diagonalLine(recipeOutput, Ingredient.of(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.REBAR.get(), 6, "rebar_invar");
        RollingRecipePattern.diagonalLine(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.REBAR.get(), 8, "rebar_steel");
    }

    private static void buildElectrodes(RecipeOutput recipeOutput) {
        RollingRecipePattern.line(recipeOutput, Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL}), (ItemLike)RailcraftItems.CARBON_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.NICKEL_PLATE), (ItemLike)RailcraftItems.NICKEL_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.IRON_PLATE), (ItemLike)RailcraftItems.IRON_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.ZINC_PLATE), (ItemLike)RailcraftItems.ZINC_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.SILVER_PLATE), (ItemLike)RailcraftItems.SILVER_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_PLATE), (ItemLike)RailcraftItems.STEEL_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.TIN_PLATE), (ItemLike)RailcraftItems.TIN_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.GOLD_PLATE), (ItemLike)RailcraftItems.GOLD_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.LEAD_PLATE), (ItemLike)RailcraftItems.LEAD_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.BRASS_PLATE), (ItemLike)RailcraftItems.BRASS_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.INVAR_PLATE), (ItemLike)RailcraftItems.INVAR_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.BRONZE_PLATE), (ItemLike)RailcraftItems.BRONZE_ELECTRODE.get(), 1);
        RollingRecipePattern.line(recipeOutput, Ingredient.of(RailcraftTags.Items.COPPER_PLATE), (ItemLike)RailcraftItems.COPPER_ELECTRODE.get(), 1);
    }

    private static void buildRails(RecipeOutput recipeOutput) {
        RollingRecipePattern.parallelLines(recipeOutput, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 8, "standard_rail");
        RollingRecipePattern.parallelLines(recipeOutput, Ingredient.of(RailcraftTags.Items.BRONZE_INGOT), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 8, "bronze_rail");
        RollingRecipePattern.parallelLines(recipeOutput, Ingredient.of(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 12, "invar_rail");
        RollingRecipePattern.parallelLines(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 16, "steel_rail");
        RollingRecipePattern.parallelLines(recipeOutput, Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get(), 6, "copper_electric_rail");
        RollingRecipePattern.parallelLines(recipeOutput, Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (ItemLike)RailcraftItems.ADVANCED_RAIL.get(), 8, "advanced_rail");
        RollingRecipePattern.parallelThreeLines(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_INGOT), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get(), 8, "standard_high_speed_rail");
        RollingRecipePattern.parallelThreeLines(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_INGOT), Ingredient.of(RailcraftTags.Items.OBSIDIAN_DUST), Ingredient.of(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.REINFORCED_RAIL.get(), 8, "steel_reinforced_rail");
        RollingRecipePattern.parallelThreeLines(recipeOutput, Ingredient.of(RailcraftTags.Items.INVAR_INGOT), Ingredient.of(RailcraftTags.Items.OBSIDIAN_DUST), Ingredient.of(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.REINFORCED_RAIL.get(), 4, "invar_reinforced_rail");
        RollingRecipePattern.parallelThreeLines(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_INGOT), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get(), 12);
    }

    private static void buildPlates(RecipeOutput recipeOutput) {
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.IRON_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), (ItemLike)RailcraftItems.GOLD_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), (ItemLike)RailcraftItems.COPPER_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.STEEL_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.NICKEL_INGOT), (ItemLike)RailcraftItems.NICKEL_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.INVAR_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.BRASS_INGOT), (ItemLike)RailcraftItems.BRASS_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.TIN_INGOT), (ItemLike)RailcraftItems.TIN_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.BRONZE_INGOT), (ItemLike)RailcraftItems.BRONZE_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.LEAD_INGOT), (ItemLike)RailcraftItems.LEAD_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.SILVER_INGOT), (ItemLike)RailcraftItems.SILVER_PLATE.get(), 4);
        RollingRecipePattern.square2x2(recipeOutput, Ingredient.of(RailcraftTags.Items.ZINC_INGOT), (ItemLike)RailcraftItems.ZINC_PLATE.get(), 4);
    }
}

