/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ItemStackHandlerCodec
implements Codec<ItemStackHandler> {
    public static final ItemStackHandlerCodec INSTANCE = new ItemStackHandlerCodec();

    public <T> DataResult<Pair<ItemStackHandler, T>> decode(DynamicOps<T> ops, T input) {
        RegistryOps.RegistryInfoLookup registryInfoLookup;
        block3: {
            block2: {
                if (!(ops instanceof RegistryOps)) break block2;
                RegistryOps regOps = (RegistryOps)ops;
                registryInfoLookup = regOps.lookupProvider;
                if (registryInfoLookup instanceof RegistryOps.HolderLookupAdapter) break block3;
            }
            return DataResult.error(() -> "Was not passed registry ops for serialization; cannot continue.");
        }
        RegistryOps.HolderLookupAdapter adapter = (RegistryOps.HolderLookupAdapter)registryInfoLookup;
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        int maxSize = (Integer)Codec.INT.fieldOf("Size").decode(ops, map).getOrThrow();
        ItemStackHandler handler = new ItemStackHandler(maxSize);
        CompoundTag.CODEC.listOf().fieldOf("Items").decode(ops, map).ifSuccess(itemTags -> itemTags.forEach(itemTag -> {
            int slot = itemTag.getInt("Slot");
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)adapter.lookupProvider, (CompoundTag)itemTag);
            handler.setStackInSlot(slot, stack);
        }));
        return DataResult.success((Object)Pair.of((Object)handler, input));
    }

    public <T> DataResult<T> encode(ItemStackHandler input, DynamicOps<T> ops, T prefix) {
        RegistryOps.RegistryInfoLookup registryInfoLookup;
        block4: {
            block3: {
                if (!(ops instanceof RegistryOps)) break block3;
                RegistryOps regOps = (RegistryOps)ops;
                registryInfoLookup = regOps.lookupProvider;
                if (registryInfoLookup instanceof RegistryOps.HolderLookupAdapter) break block4;
            }
            return DataResult.error(() -> "Was not passed registry ops for serialization; cannot continue.");
        }
        RegistryOps.HolderLookupAdapter adapter = (RegistryOps.HolderLookupAdapter)registryInfoLookup;
        ListBuilder list = ops.listBuilder();
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack inSlot = input.getStackInSlot(i);
            if (inSlot.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            Tag encodedStack = inSlot.save(adapter.lookupProvider, (Tag)itemTag);
            if (!(encodedStack instanceof CompoundTag)) continue;
            CompoundTag ct = (CompoundTag)encodedStack;
            list.add(CompoundTag.CODEC.encode((Object)ct, ops, ops.empty()));
        }
        return ops.mapBuilder().add("Items", list.build(ops.empty())).add("Size", ops.createInt(input.getSlots())).build(prefix);
    }
}

