/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.server.service;

import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.upgrade.IRoomUpgradeAccessor;
import dev.compactmods.machines.api.room.upgrade.IRoomUpgradeManager;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstance;
import dev.compactmods.machines.server.service.CMServerRoomUpgradeAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class CMServerRoomUpgradeManager
implements IRoomUpgradeManager {
    private final Map<UUID, String> INSTANCE_LOCATIONS;
    private final Map<String, CMServerRoomUpgradeAccessor> ACCESSORS = new Object2ObjectOpenHashMap();

    public CMServerRoomUpgradeManager() {
        this.INSTANCE_LOCATIONS = new Object2ObjectOpenHashMap();
    }

    public void removeInstance(UUID uuid) {
        String existing = this.INSTANCE_LOCATIONS.remove(uuid);
        if (existing != null) {
            CMServerRoomUpgradeAccessor room = this.ACCESSORS.get(existing);
            room.remove(uuid);
        }
    }

    public Optional<RoomUpgradeInstance> get(UUID uuid) {
        if (!this.INSTANCE_LOCATIONS.containsKey(uuid)) {
            return Optional.empty();
        }
        String inRoom = this.INSTANCE_LOCATIONS.get(uuid);
        return this.ACCESSORS.get(inRoom).getExistingInstance(uuid);
    }

    public Stream<UUID> allUpgradesIDs() {
        return this.INSTANCE_LOCATIONS.keySet().stream();
    }

    public Stream<RoomUpgradeInstance> allUpgrades() {
        return this.allUpgradesIDs().map(this::get).filter(Optional::isPresent).map(Optional::get);
    }

    public IRoomUpgradeAccessor upgradeAccessor(RoomInstance roomInstance) {
        return this.ACCESSORS.computeIfAbsent(roomInstance.code(), roomCode -> new CMServerRoomUpgradeAccessor(roomInstance));
    }

    public void clearCache() {
        this.INSTANCE_LOCATIONS.clear();
        this.ACCESSORS.forEach((code, accessor) -> accessor.clearCache());
    }
}

