/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.server.event;

import dev.compactmods.machines.api.room.template.RoomTemplateHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class RoomTemplatesCheckEventHandler {
    public static void onAdminJoinedLevel(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        MinecraftServer serv = serverPlayer.getServer();
        if (serv == null) {
            return;
        }
        boolean isOp = serv.getPlayerList().isOp(serverPlayer.getGameProfile());
        if (!isOp) {
            return;
        }
        long numTemplates = RoomTemplateHelper.getTemplates((RegistryAccess)serv.registryAccess()).count();
        if (numTemplates == 0L && isOp) {
            MutableComponent displayName = Component.translatableWithFallback((String)"compactmachines.display_name", (String)"Compact Machines");
            MutableComponent action = Component.translatableWithFallback((String)"compactmachines.warning.no_templates.action", (String)"[click here]").withStyle(s -> s.withColor(-171).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/compactmachines enable_basic_templates")).withUnderlined(Boolean.valueOf(true)));
            MutableComponent warning = Component.translatableWithFallback((String)"compactmachines.warning.no_templates_registered", (String)"No Room Templates are registered! If you believe this is a mistake, %s to enable the built-in templates and hide this message.", (Object[])new Object[]{action}).withColor(-2142128);
            MutableComponent message = Component.literal((String)"[").append((Component)displayName).append("] ").append((Component)warning).append(CommonComponents.NEW_LINE);
            serverPlayer.sendSystemMessage((Component)message);
        }
    }

    public static void registerEvents() {
        NeoForge.EVENT_BUS.addListener(RoomTemplatesCheckEventHandler::onAdminJoinedLevel);
    }
}

