/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.capability.RoomCapabilities;
import dev.compactmods.machines.api.room.upgrade.IRoomUpgradeAccessor;
import dev.compactmods.machines.api.room.upgrade.IRoomUpgradeManager;
import dev.compactmods.machines.api.room.upgrade.inventory.RoomUpgradeInventory;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;

public class RoomUpgradeHelper {
    public static void cleanDeadUpgrades(RoomInstance roomInstance) {
        RoomUpgradeInventory upgradeInv = (RoomUpgradeInventory)roomInstance.getData(CMDataAttachments.UPGRADE_ITEMS);
        IRoomUpgradeAccessor upgradeReg = (IRoomUpgradeAccessor)roomInstance.getCapability(RoomCapabilities.UPGRADES);
        if (upgradeInv.items().allMatch(ItemStack::isEmpty)) {
            upgradeReg.clearCache();
            return;
        }
        List<ItemStack> upgradeItems = upgradeInv.items().filter(Predicate.not(ItemStack::isEmpty)).toList();
    }

    public static void verifyChunkloaderUpgrades(ServerLevel serverLevel, TicketHelper ticketHelper) {
        IRoomUpgradeManager manager = CompactMachines.upgradeManager();
        if (manager == null) {
            return;
        }
        Map tickets = ticketHelper.getEntityTickets();
        tickets.keySet().forEach(arg_0 -> ((TicketHelper)ticketHelper).removeAllTickets(arg_0));
    }
}

