/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.api.room.data.CMRoomDataLocations;
import dev.compactmods.machines.data.AttachmentBasedDataFile;
import dev.compactmods.machines.data.AttachmentDataFileFactoryInput;
import java.nio.file.Path;
import net.minecraft.server.MinecraftServer;

public class RoomDataAttachments
extends AttachmentBasedDataFile<RoomDataAttachments, AdditionalData>
implements AutoCloseable {
    private final String roomCode;

    @Override
    public void close() throws Exception {
    }

    public RoomDataAttachments(MinecraftServer server, String roomCode) {
        super(server, AdditionalData.CODEC, RoomDataAttachments::new);
        this.roomCode = roomCode;
    }

    public RoomDataAttachments(AttachmentDataFileFactoryInput<AdditionalData> fromCodec) {
        super(fromCodec.server(), AdditionalData.CODEC, RoomDataAttachments::new);
        this.roomCode = fromCodec.additionalData().roomCode();
    }

    @Override
    public Path getDataLocation(MinecraftServer server) {
        return (Path)CMRoomDataLocations.ROOM_DATA_ATTACHMENTS.apply(server);
    }

    @Override
    public Codec<RoomDataAttachments> codec() {
        return this.codec;
    }

    @Override
    protected AdditionalData dataSupplier(RoomDataAttachments instance) {
        return new AdditionalData(instance.roomCode);
    }

    public record AdditionalData(String roomCode) {
        public static final MapCodec<AdditionalData> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.fieldOf("room_code").forGetter(x -> x.roomCode)).apply((Applicative)i, AdditionalData::new));
    }
}

