/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.registration.IRoomBuilder;
import dev.compactmods.machines.api.room.registration.IRoomRegistrar;
import dev.compactmods.machines.api.room.spatial.IRoomBoundaries;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.data.manager.CMSingletonDataFileManager;
import dev.compactmods.machines.room.NewRoomBuilder;
import dev.compactmods.machines.room.RoomRegistrarData;
import dev.compactmods.machines.room.graph.node.RoomRegistrationNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class CMRoomRegistrar
implements IRoomRegistrar,
AutoCloseable {
    private final MinecraftServer server;
    private final CMSingletonDataFileManager<RoomRegistrarData> ROOM_REGISTRAR_DATA;
    private final Map<String, RoomInstance> instanceCache = new Object2ObjectArrayMap();

    public CMRoomRegistrar(MinecraftServer server) {
        this.server = server;
        this.ROOM_REGISTRAR_DATA = new CMSingletonDataFileManager<RoomRegistrarData>(server, "room_registrations", new RoomRegistrarData(server));
        this.ROOM_REGISTRAR_DATA.load();
    }

    public AABB getNextBoundaries(RoomTemplate template) {
        return this.ROOM_REGISTRAR_DATA.data().getNextBoundaries(template);
    }

    public IRoomBuilder builder() {
        return new NewRoomBuilder();
    }

    public boolean isRegistered(String room) {
        return this.ROOM_REGISTRAR_DATA.data().isRegistered(room);
    }

    public Optional<RoomInstance> get(String room) {
        return this.ROOM_REGISTRAR_DATA.data().get(room).map(this::getOrMakeRoomInstance);
    }

    public long count() {
        return this.ROOM_REGISTRAR_DATA.data().count();
    }

    public Stream<String> allRoomCodes() {
        if (this.ROOM_REGISTRAR_DATA == null) {
            return Stream.empty();
        }
        return this.ROOM_REGISTRAR_DATA.data().allRoomCodes();
    }

    public Stream<RoomInstance> allRooms() {
        if (this.ROOM_REGISTRAR_DATA == null) {
            return Stream.empty();
        }
        return this.ROOM_REGISTRAR_DATA.data().allRoomData().map(this::getOrMakeRoomInstance);
    }

    public void save() {
        if (this.ROOM_REGISTRAR_DATA == null) {
            return;
        }
        this.ROOM_REGISTRAR_DATA.save();
    }

    public RoomInstance createNew(RoomTemplate template, UUID owner, Consumer<IRoomBuilder> override) {
        Consumer<IRoomBuilder> preOverride = builder -> builder.defaultMachineColor(template.defaultMachineColor()).owner(owner).boundaries(this.getNextBoundaries(template));
        NewRoomBuilder b = new NewRoomBuilder();
        preOverride.andThen(override).accept(b);
        RoomInstance inst = b.build(this.server);
        RoomRegistrationNode node = new RoomRegistrationNode(UUID.randomUUID(), new RoomRegistrationNode.Data(inst));
        this.ROOM_REGISTRAR_DATA.data().put(node);
        CompactMachines.chunkManager().calculateChunks(inst.code(), (IRoomBoundaries)node);
        this.instanceCache.put(inst.code(), inst);
        return inst;
    }

    @NotNull
    private RoomInstance getOrMakeRoomInstance(RoomRegistrationNode regNode) {
        if (this.instanceCache.containsKey(regNode.code())) {
            return this.instanceCache.get(regNode.code());
        }
        RoomInstance inst = new RoomInstance(this.server, CompactDimension.LEVEL_KEY, regNode.code(), regNode.defaultMachineColor(), (IRoomBoundaries)regNode);
        this.instanceCache.put(regNode.code(), inst);
        return inst;
    }

    @Override
    public void close() throws Exception {
        this.save();
    }
}

