/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.rooms;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.command.rooms.CMFindRoomSubcommand;
import dev.compactmods.machines.i18n.CommandTranslations;
import java.util.stream.LongStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class CMRoomsSubcommand {
    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = LiteralArgumentBuilder.literal((String)"rooms");
        LiteralArgumentBuilder summary = (LiteralArgumentBuilder)Commands.literal((String)"summary").executes(CMRoomsSubcommand::execRoomSummary);
        subRoot.then((ArgumentBuilder)summary);
        subRoot.then(CMFindRoomSubcommand.create());
        return subRoot;
    }

    private static int execRoomSummary(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.getServer();
        LongStream.Builder ls = LongStream.builder();
        long roomCount = CompactMachines.roomRegistrar().count();
        src.sendSuccess(() -> Component.translatable((String)CommandTranslations.IDs.ROOM_COUNT, (Object[])new Object[]{roomCount}), false);
        return 0;
    }
}

