/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.room;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.gander.render.geometry.BakedLevel;
import dev.compactmods.gander.ui.widget.SpatialRenderer;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.shrinking.PSDTags;
import dev.compactmods.machines.client.config.ClientConfig;
import dev.compactmods.machines.client.widget.ImageButtonBuilder;
import dev.compactmods.machines.compat.curios.CuriosCompat;
import dev.compactmods.machines.feature.CMFeatureFlags;
import dev.compactmods.machines.network.room.PlayerRequestedTeleportPacket;
import dev.compactmods.machines.network.room.PlayerRequestedUpgradeUIPacket;
import dev.compactmods.machines.network.room.PlayerStartedRoomTrackingPacket;
import dev.compactmods.machines.shrinking.Shrinking;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class MachineRoomScreen
extends Screen {
    private final GlobalPos machinePos;
    private final String roomCode;
    private SpatialRenderer renderer;
    private AABB renderSize;
    private ImageButton psdButton;
    private ScreenRectangle screenArea;
    private boolean isLoadingRoomPreview;
    private boolean roomPreviewEnabled = true;

    public MachineRoomScreen(Component title, GlobalPos machinePos, String roomCode) {
        super(title);
        this.machinePos = machinePos;
        this.roomCode = roomCode;
        if (((Boolean)ClientConfig.ENABLE_ROOM_PREVIEWS.get()).booleanValue()) {
            this.isLoadingRoomPreview = true;
            PacketDistributor.sendToServer((CustomPacketPayload)new PlayerStartedRoomTrackingPacket(roomCode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            this.roomPreviewEnabled = false;
        }
    }

    protected void init() {
        super.init();
        WidgetSprites psdBtnSprites = new WidgetSprites(CompactMachines.modRL((String)"personal_shrinking_device"), CompactMachines.modRL((String)"personal_shrinking_device_disabled"), CompactMachines.modRL((String)"personal_shrinking_device_highlighted"), CompactMachines.modRL((String)"personal_shrinking_device_disabled"));
        this.screenArea = new ScreenRectangle(this.width / 2 - 130, this.height / 2 - 120, 260, 260);
        this.psdButton = ImageButtonBuilder.button(psdBtnSprites).size(12, 12).location(this.screenArea.right() - 12, this.screenArea.bottom() + 2).onPress(btn -> PacketDistributor.sendToServer((CustomPacketPayload)new PlayerRequestedTeleportPacket(this.machinePos, this.roomCode), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
        this.addRenderableWidget((GuiEventListener)this.psdButton);
        this.roomUpgradesButton();
    }

    public void tick() {
        super.tick();
        this.psdButton.active = MachineRoomScreen.checkForShrinkingDevice();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        float rotateSpeed = 0.083333336f;
        if (this.roomPreviewEnabled) {
            if (keyCode == 82) {
                this.renderer.camera().resetLook();
                this.renderer.recalculateTranslucency();
                return true;
            }
            if (keyCode == 265) {
                this.renderer.camera().lookUp(0.083333336f);
                this.renderer.recalculateTranslucency();
                return true;
            }
            if (keyCode == 264) {
                this.renderer.camera().lookDown(0.083333336f);
                this.renderer.recalculateTranslucency();
                return true;
            }
            if (keyCode == 263) {
                this.renderer.camera().lookLeft(0.083333336f);
                this.renderer.recalculateTranslucency();
                return true;
            }
            if (keyCode == 262) {
                this.renderer.camera().lookRight(0.083333336f);
                this.renderer.recalculateTranslucency();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.roomPreviewEnabled && this.renderer != null) {
            Vec3 camPosition = this.renderer.camera().getPosition();
            if (scrollY > 0.0 && camPosition.distanceTo(Vec3.ZERO) >= 2.0) {
                this.renderer.zoom(scrollY);
            }
            if (scrollY < 0.0 && camPosition.distanceTo(Vec3.ZERO) <= 100.0) {
                this.renderer.zoom(scrollY);
            }
            return true;
        }
        return false;
    }

    private static boolean checkForShrinkingDevice() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        boolean hasPsdInInv = player.getInventory().contains(slotItem -> slotItem.has(Shrinking.DataComponents.SHRINKING_CONFIG) || slotItem.is(PSDTags.ITEM));
        if (hasPsdInInv) {
            return true;
        }
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.hasPsdCurio((LivingEntity)player);
        }
        return false;
    }

    private void roomUpgradesButton() {
        if (this.minecraft == null || this.minecraft.getConnection() == null) {
            return;
        }
        if (CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(this.minecraft.getConnection().enabledFeatures())) {
            WidgetSprites upgradeBtnSprites = new WidgetSprites(CompactMachines.modRL((String)"upgrade_btn"), CompactMachines.modRL((String)"upgrade_btn"));
            ImageButton upgradeScreenBtn = ImageButtonBuilder.button(upgradeBtnSprites).size(12, 12).location(this.screenArea.right() - 24, this.screenArea.bottom() + 2).onPress(btn -> PacketDistributor.sendToServer((CustomPacketPayload)new PlayerRequestedUpgradeUIPacket(this.roomCode, false), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
            this.addRenderableWidget((GuiEventListener)upgradeScreenBtn);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 100.0f);
        guiGraphics.fill(this.screenArea.left() - 1, this.screenArea.top() - 1, this.screenArea.right() + 1, this.screenArea.bottom() + 1, FastColor.ARGB32.color((int)180, (int)-1));
        guiGraphics.fill(this.screenArea.left(), this.screenArea.top(), this.screenArea.right(), this.screenArea.bottom(), FastColor.ARGB32.color((int)250, (int)8, (int)90, (int)120));
        pose.popPose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        MutableComponent loadingMsg;
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        PoseStack pose = graphics.pose();
        pose.pushPose();
        MutableComponent rt = Component.literal((String)this.roomCode);
        int n = this.width / 2;
        int n2 = this.screenArea.top();
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(this.font, (Component)rt, n, n2 - 9 - 2, -2171170);
        pose.popPose();
        if (this.roomPreviewEnabled && this.isLoadingRoomPreview) {
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 110.0f);
            loadingMsg = Component.translatableWithFallback((String)"compactmachines.preview.loading", (String)"Loading room preview...");
            int n3 = this.width / 2;
            int n4 = this.height / 2;
            Objects.requireNonNull(this.font);
            graphics.drawCenteredString(this.font, (Component)loadingMsg, n3, n4 - 9 / 2, -2171170);
            pose.popPose();
        }
        if (!this.roomPreviewEnabled) {
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 110.0f);
            loadingMsg = Component.translatableWithFallback((String)"compactmachines.preview.disabled", (String)"Room Preview Disabled");
            int n5 = this.width / 2;
            int n6 = this.height / 2;
            Objects.requireNonNull(this.font);
            graphics.drawCenteredString(this.font, (Component)loadingMsg, n5, n6 - 9 / 2, -2171170);
            pose.popPose();
        }
        pose.pushPose();
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
        pose.popPose();
    }

    public void onClose() {
        super.onClose();
    }

    public void updateSceneRenderer(CompletableFuture<BakedLevel> future) {
        this.isLoadingRoomPreview = true;
        future.thenAcceptAsync(this::updateScene);
    }

    public void updateScene(BakedLevel bakedLevel) {
        if (this.renderer != null) {
            this.renderables.remove(this.renderer);
        }
        this.renderer = (SpatialRenderer)this.addRenderableOnly((Renderable)new SpatialRenderer(bakedLevel, this.screenArea.left(), this.screenArea.top(), this.screenArea.width(), this.screenArea.height()));
        this.renderSize = bakedLevel.blockBoundaries();
        this.renderer.camera().zoom(MachineRoomScreen.calculateZoomForRoom(this.renderSize));
        this.renderer.camera().lookUp(0.25f);
        this.isLoadingRoomPreview = false;
    }

    private static float calculateZoomForRoom(AABB internalSize) {
        boolean isCube;
        boolean tallRoom = Math.max(internalSize.getXsize(), internalSize.getZsize()) < internalSize.getYsize();
        boolean sidesEqual = internalSize.getXsize() == internalSize.getZsize();
        boolean bl = isCube = sidesEqual && internalSize.getZsize() == internalSize.getYsize();
        if (isCube) {
            return -1.0f * (float)Math.sqrt(Math.pow(internalSize.getXsize(), 2.0) * 3.0);
        }
        if (sidesEqual) {
            double cSquared = Math.sqrt(Math.pow(internalSize.getXsize(), 2.0) * 2.0 + Math.pow(internalSize.getYsize(), 2.0));
            return (float)(-1.0 * cSquared);
        }
        double cSquared = Math.sqrt(Math.pow(internalSize.getXsize(), 2.0) + Math.pow(internalSize.getYsize(), 2.0) + Math.pow(internalSize.getZsize(), 2.0));
        return (float)(-1.0 * cSquared);
    }
}

