/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen.recipe.provider;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.conditions.BeeExistsCondition;
import cy.jdkdigital.productivebees.datagen.recipe.builder.CentrifugeRecipeBuilder;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.HiveType;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.fluids.FluidStack;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider
implements IConditionBuilder {
    private final CompletableFuture<HolderLookup.Provider> pRegistries;

    public RecipeProvider(PackOutput gen, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(gen, pRegistries);
        this.pRegistries = pRegistries;
    }

    public String getName() {
        return "PB Recipes";
    }

    protected void buildRecipes(RecipeOutput consumer) {
        ModBlocks.HIVELIST.forEach((modid, strings) -> strings.forEach((name, type) -> {
            if (ProductiveBees.includeMod(modid)) {
                name = modid.equals("productivebees") ? name : modid + "_" + name;
                this.buildHiveRecipe((String)modid, (String)name, (HiveType)type, consumer);
                this.buildBoxRecipe((String)modid, (String)name, (HiveType)type, consumer);
                if (modid.equals("productivebees")) {
                    this.buildCanvasRecipes((String)name, consumer);
                }
            }
        }));
        ModBlocks.hiveStyles.forEach(style -> {
            this.buildCanvasStonecutterRecipes((String)style, consumer);
            this.buildCanvasCorailWoodcutterRecipes((String)style, consumer);
        });
        Arrays.stream(DyeColor.values()).forEach(dyeColor -> {
            Block h = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)(dyeColor.getSerializedName() + "_petrified_honey")));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)h).requires((ItemLike)ModBlocks.PETRIFIED_HONEY.get()).requires(dyeColor.getTag()).unlockedBy("has_honey", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.PETRIFIED_HONEY.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("petrified_honey/" + dyeColor.getSerializedName())));
        });
        ArrayList<CentrifugeRecipeBuilder.RecipeConfig> ingots = new ArrayList<CentrifugeRecipeBuilder.RecipeConfig>(){
            {
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("blutonium", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/blutonium", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("cyanite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/cyanite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("inanite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/inanite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("insanite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/insanite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("ludicrite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/ludicrite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("magentite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/magentite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("ridiculite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/ridiculite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("graphite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#c:ingots/graphite", new HashMap<String, String>()));
            }
        };
        ingots.forEach(config -> {
            CentrifugeRecipeBuilder recipe = CentrifugeRecipeBuilder.configurable(config.name()).addOutput(new TagOutputRecipe.ChancedOutput(Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)config.centrifugeOutput().replace("#", "")))), 1, 1, 1.0f)).setFluidOutput(new FluidStack(ModFluids.HONEY, 50));
            if (config.centrifugeOutput().startsWith("#")) {
                recipe.withCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(config.centrifugeOutput().replace("#", ""))));
            }
            recipe.save(consumer.withConditions(new ICondition[]{new BeeExistsCondition(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)config.name()))}), ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("centrifuge/" + config.folder() + "/honeycomb_" + config.name())));
        });
    }

    private void buildHiveRecipe(String modid, String name, HiveType type, RecipeOutput consumer) {
        try {
            Optional plank;
            Optional optional = plank = type.planks() != null ? Optional.of(type.planks()) : BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)type.customPlank().blockName));
            if (plank.isPresent()) {
                Block hive = (Block)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get();
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).group("hives").pattern("WWW").pattern("CHC").pattern("FWS").define(Character.valueOf('W'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)plank.get()})).define(Character.valueOf('H'), Ingredient.of(ModTags.Common.HIVES)).define(Character.valueOf('C'), Ingredient.of(ModTags.Common.HONEYCOMBS)).define(Character.valueOf('F'), Ingredient.of(ModTags.Common.CAMPFIRES)).define(Character.valueOf('S'), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR)).unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).save(consumer.withConditions(new ICondition[]{this.modLoaded(modid)}), ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("hives/advanced_" + name + "_beehive")));
                this.buildHiveResetRecipes(modid, hive, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("hives/advanced_" + name + "_beehive_clear")), consumer);
            }
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.warn("error generating hive recipe for " + name + " " + e.getMessage());
            ProductiveBees.LOGGER.warn("planks " + String.valueOf(type.planks()));
        }
    }

    private void buildBoxRecipe(String modid, String name, HiveType type, RecipeOutput consumer) {
        try {
            Optional plank;
            Optional optional = plank = type.planks() != null ? Optional.of(type.planks()) : BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)type.customPlank().blockName));
            if (plank.isPresent()) {
                Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get();
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)box).group("expansion_boxes").pattern("WWW").pattern("WCW").pattern("WWW").define(Character.valueOf('W'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)plank.get()})).define(Character.valueOf('C'), Ingredient.of(ModTags.Common.HONEYCOMBS)).unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).save(consumer.withConditions(new ICondition[]{this.modLoaded(modid)}), ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("expansion_boxes/expansion_box_" + name)));
            }
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.warn("error generating box recipe for " + name + " " + e.getMessage());
            ProductiveBees.LOGGER.warn("planks " + String.valueOf(type.planks()));
        }
    }

    private void buildCanvasRecipes(String style, RecipeOutput consumer) {
        Block hivein = (Block)ModBlocks.HIVES.get("advanced_" + style + "_beehive").get();
        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
        Block boxin = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style).get();
        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).group("hives").pattern("PPP").pattern("PHP").pattern("PPP").define(Character.valueOf('H'), Ingredient.of((ItemLike[])new ItemLike[]{hivein})).define(Character.valueOf('P'), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER})).unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("hives/advanced_" + style + "_canvas_hive")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)box).group("expansion_boxes").pattern("PPP").pattern("PHP").pattern("PPP").define(Character.valueOf('H'), Ingredient.of((ItemLike[])new ItemLike[]{boxin})).define(Character.valueOf('P'), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER})).unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("expansion_boxes/expansion_box_" + style + "_canvas")));
    }

    private void buildHiveResetRecipes(String modid, Block hive, ResourceLocation location, RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).group("hives").unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).requires((ItemLike)hive).save(consumer.withConditions(new ICondition[]{this.modLoaded(modid)}), location);
    }

    private void buildCanvasStonecutterRecipes(String style, RecipeOutput consumer) {
        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of(ModTags.CANVAS_HIVES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).group("hives").unlockedBy("has_hive", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).unlockedBy("has_stonecutter", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STONECUTTER})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("stonecutter/" + style + "_canvas_hive")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of(ModTags.CANVAS_BOXES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)box).group("expansion_boxes").unlockedBy("has_box", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEEHIVE})).unlockedBy("has_stonecutter", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STONECUTTER})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("stonecutter/" + style + "_canvas_expansion_box")));
    }

    private void buildCanvasCorailWoodcutterRecipes(String style, RecipeOutput consumer) {
        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
    }
}

