/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.ColorUtil;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneGroup;
import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class Gene
extends Item {
    public static float color(ItemStack itemStack) {
        return switch (Gene.getAttribute(itemStack)) {
            default -> throw new MatchException(null, null);
            case GeneAttribute.TYPE -> 0.0f;
            case GeneAttribute.PRODUCTIVITY -> 0.1f;
            case GeneAttribute.ENDURANCE -> 0.2f;
            case GeneAttribute.TEMPER -> 0.3f;
            case GeneAttribute.BEHAVIOR -> 0.4f;
            case GeneAttribute.WEATHER_TOLERANCE -> 0.5f;
        };
    }

    public Gene(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(GeneAttribute attribute, String value) {
        return Gene.getStack(attribute, value, 1);
    }

    public static ItemStack getStack(GeneAttribute attribute, String value, int count) {
        return Gene.getStack(attribute, value, count, ProductiveBees.random.nextInt(40) + 15);
    }

    public static ItemStack getStack(String type, int purity) {
        return Gene.getStack(GeneAttribute.TYPE, type, 1, purity);
    }

    public static ItemStack getStack(GeneAttribute attribute, GeneValue value, int count, int purity) {
        return Gene.getStack(attribute, value.getSerializedName(), count, purity);
    }

    public static ItemStack getStack(GeneAttribute attribute, String value, int count, int purity) {
        ItemStack result = new ItemStack((ItemLike)ModItems.GENE.get(), count);
        Gene.setGenes(result, attribute, value, purity);
        return result;
    }

    public static ItemStack getStack(GeneGroup geneGroup, int count) {
        ItemStack result = new ItemStack((ItemLike)ModItems.GENE.get(), count);
        Gene.setGenes(result, geneGroup);
        return result;
    }

    public static void setGenes(ItemStack stack, GeneAttribute attribute, String value, int purity) {
        stack.set(ModDataComponents.GENE_GROUP, (Object)new GeneGroup(attribute, value, purity));
    }

    public static void setGenes(ItemStack stack, GeneGroup geneGroup) {
        stack.set(ModDataComponents.GENE_GROUP, (Object)geneGroup);
    }

    public static GeneGroup getGenes(ItemStack stack) {
        return stack.has(ModDataComponents.GENE_GROUP) ? (GeneGroup)stack.get(ModDataComponents.GENE_GROUP) : null;
    }

    public static GeneAttribute getAttribute(ItemStack stack) {
        return stack.has(ModDataComponents.GENE_GROUP) ? ((GeneGroup)stack.get(ModDataComponents.GENE_GROUP)).attribute() : GeneAttribute.TYPE;
    }

    public static String getValue(ItemStack stack) {
        return stack.has(ModDataComponents.GENE_GROUP) ? ((GeneGroup)stack.get(ModDataComponents.GENE_GROUP)).value() : "";
    }

    public static Integer getPurity(ItemStack stack) {
        return stack.has(ModDataComponents.GENE_GROUP) ? ((GeneGroup)stack.get(ModDataComponents.GENE_GROUP)).purity() : 0;
    }

    public static GeneGroup getGene(ItemStack geneStack) {
        return (GeneGroup)geneStack.get(ModDataComponents.GENE_GROUP);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        GeneAttribute attribute = Gene.getAttribute(pStack);
        String value = Gene.getValue(pStack);
        if (attribute != null && GeneValue.byName(value) != null) {
            MutableComponent translatedValue = Component.translatable((String)("productivebees.information.attribute." + value)).withStyle(ColorUtil.getAttributeColor(GeneValue.byName(value)));
            pTooltipComponents.add((Component)Component.translatable((String)("productivebees.information.attribute." + attribute.getSerializedName()), (Object[])new Object[]{translatedValue}).withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)(" (" + Gene.getPurity(pStack) + "%)"))));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.attribute.type", (Object[])new Object[]{value}).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(" (" + Gene.getPurity(pStack) + "%)"))));
        }
    }
}

