/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.entity.CanvasExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.compat.dyenamics.DyenamicsCompat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class CanvasExpansionBox
extends ExpansionBox {
    public CanvasExpansionBox(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CanvasExpansionBoxBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CanvasExpansionBoxBlockEntity) {
            CanvasExpansionBoxBlockEntity canvasExpansionBoxBlockEntity = (CanvasExpansionBoxBlockEntity)blockEntity;
            int color = 0;
            if (ModList.get().isLoaded("dyenamics") && DyenamicsCompat.isDye(stack)) {
                color = DyenamicsCompat.getColor(stack);
            } else {
                Item item = stack.getItem();
                if (item instanceof DyeItem) {
                    DyeItem dye = (DyeItem)item;
                    color = dye.getDyeColor().getTextureDiffuseColor();
                }
            }
            if (color != 0) {
                canvasExpansionBoxBlockEntity.setColor(color);
                if (!pLevel.isClientSide() && !pPlayer.isCreative()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        Object style = pStack.getItem().getDescriptionId().replace("block.productivebees.expansion_box_", "").replace("_canvas", "");
        style = ((String)style).substring(0, 1).toUpperCase() + ((String)style).substring(1);
        pTootipComponents.add((Component)Component.translatable((String)"productivebees.information.canvas.style", (Object[])new Object[]{Component.literal((String)style).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.WHITE));
    }
}

