/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import java.util.EnumSet;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class RootminHiddenGoal
extends Goal {
    protected final RootminEntity mob;
    protected int unhidingTimer = 0;

    public RootminHiddenGoal(RootminEntity pathfinderMob) {
        this.mob = pathfinderMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.mob.isHidden;
    }

    public boolean canContinueToUse() {
        return (this.unhidingTimer > 0 || this.mob.isHidden) && this.mob.hurtTime == 0 && !this.mob.isDeadOrDying();
    }

    public void start() {
        this.mob.stayHidingTimer = 200;
        this.unhidingTimer = 0;
    }

    public void stop() {
    }

    public void tick() {
        if (!this.mob.isPassenger()) {
            float lookAngle = this.mob.getYRot();
            Direction direction = Direction.fromYRot((double)lookAngle);
            Vec3 lookVec = Vec3.atLowerCornerOf((Vec3i)direction.getNormal()).add(this.mob.position());
            this.mob.getLookControl().setLookAt(lookVec.x(), lookVec.y(), lookVec.z(), 60.0f, 0.0f);
            this.mob.setYRot(direction.toYRot());
        }
        if (this.mob.stayHidingTimer == 0) {
            int distance;
            LivingEntity target;
            if (this.unhidingTimer > 0) {
                --this.unhidingTimer;
            } else if (!(this.unhidingTimer != 0 || (target = this.mob.getTarget()) == null || (distance = target.blockPosition().distManhattan((Vec3i)this.mob.blockPosition())) < 8 || distance > 26 || target instanceof Player && RootminEntity.isFacingMob(this.mob, target))) {
                this.unhidingTimer = 20;
                this.mob.exposeFromBlock();
                this.mob.exposedTimer = 160;
                this.mob.takePotShot = true;
            }
        } else {
            --this.mob.stayHidingTimer;
        }
    }
}

