/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.ProperFacingBlock;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HoneyCrystal
extends ProperFacingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape UP_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    public static final Map<Direction, VoxelShape> FACING_TO_SHAPE_MAP = (Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH_AABB);
        map.put(Direction.EAST, EAST_AABB);
        map.put(Direction.SOUTH, SOUTH_AABB);
        map.put(Direction.WEST, WEST_AABB);
        map.put(Direction.UP, UP_AABB);
        map.put(Direction.DOWN, DOWN_AABB);
    });
    private Item item;
    public static final MapCodec<HoneyCrystal> CODEC = Block.simpleCodec(HoneyCrystal::new);

    public HoneyCrystal() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).instrument(NoteBlockInstrument.HAT).lightLevel(blockState -> 1).strength(0.3f, 0.3f).sound((SoundType)BzSounds.HONEY_CRYSTALS_TYPE).noOcclusion().pushReaction(PushReaction.DESTROY));
    }

    public HoneyCrystal(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public MapCodec<? extends HoneyCrystal> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState blockstate, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return FACING_TO_SHAPE_MAP.get(blockstate.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)blockstate.getValue((Property)FACING);
        BlockState attachedBlockstate = world.getBlockState(pos.relative(direction.getOpposite()));
        return attachedBlockstate.isFaceSturdy((BlockGetter)world, pos.relative(direction.getOpposite()), direction);
    }

    public BlockState updateShape(BlockState blockstate, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.getOpposite() == blockstate.getValue((Property)FACING) && !blockstate.canSurvive((LevelReader)world, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)blockstate.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)world));
        }
        return super.updateShape(blockstate, facing, facingState, world, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState attachedBlockstate;
        if (!context.replacingClickedOnBlock() && (attachedBlockstate = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()))).getBlock() == this && attachedBlockstate.getValue((Property)FACING) == context.getClickedFace()) {
            return null;
        }
        BlockState blockstate = this.defaultBlockState();
        Level worldReader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)worldReader, blockpos)) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType().is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluidstate.isSource()));
        }
        return null;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        if (itemStack.getItem() == Items.GLASS_BOTTLE) {
            level.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, new ItemStack((ItemLike)BzItems.SUGAR_WATER_BOTTLE.get()), false, true);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, position, playerEntity, playerHand, raytraceResult);
    }

    public Item asItem() {
        if (this.item == null) {
            this.item = (Item)BzItems.HONEY_CRYSTAL_SHARDS.get();
        }
        return this.item;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ((Item)BzItems.HONEY_CRYSTAL.get()).getDefaultInstance();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false && fluid.is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluid.defaultFluidState().isSource();
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (!((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue() && fluidState.getType().is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) && fluidState.isSource()) {
            if (!world.isClientSide()) {
                world.setBlock(blockPos, (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.scheduleTick(blockPos, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.setBlock(blockPos, (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)BzItems.SUGAR_WATER_BUCKET.get());
        }
        return ItemStack.EMPTY;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        if (!level.isClientSide) {
            BlockPos blockPos = blockHitResult.getBlockPos();
            level.playSound(null, blockPos, (SoundEvent)BzSounds.HONEY_CRYSTAL_BLOCK_HIT.get(), SoundSource.BLOCKS, 1.0f, 0.5f + level.random.nextFloat() * 1.2f);
            level.playSound(null, blockPos, (SoundEvent)BzSounds.HONEY_CRYSTAL_BLOCK_CHIME.get(), SoundSource.BLOCKS, 1.0f, 0.5f + level.random.nextFloat() * 1.2f);
        }
    }
}

