/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.shingles.ShingleHeightType;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public final class ModCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> TAB_REG = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"domum_ornamentum");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GENERAL = TAB_REG.register("general", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModBlocks.getInstance().getArchitectsCutter())).title((Component)Component.translatable((String)"itemGroup.domum_ornamentum.general")).displayItems((CreativeModeTab.DisplayItemsGenerator)new OutputAwareGenerator((config, output) -> {
        output.accept((ItemLike)ModBlocks.getInstance().getArchitectsCutter());
        ModBlocks.getInstance().getTimberFrames().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        for (ShingleHeightType heightType : ShingleHeightType.values()) {
            output.accept((ItemLike)ModBlocks.getInstance().getShingle(heightType));
        }
        output.accept((ItemLike)ModBlocks.getInstance().getShingleSlab());
        output.accept((ItemLike)ModBlocks.getInstance().getPaperWall());
        output.accept((ItemLike)ModBlocks.getInstance().getTiledPaperWall());
        ModBlocks.getInstance().getPillars().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        ModBlocks.getInstance().getFramedLights().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        ModBlocks.getInstance().getAllBrickBlocks().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        output.accept((ItemLike)ModBlocks.getInstance().getFence());
        output.accept((ItemLike)ModBlocks.getInstance().getFenceGate());
        output.accept((ItemLike)ModBlocks.getInstance().getSlab());
        output.accept((ItemLike)ModBlocks.getInstance().getWall());
        output.accept((ItemLike)ModBlocks.getInstance().getStair());
        output.accept((ItemLike)ModBlocks.getInstance().getTrapdoor());
        output.accept((ItemLike)ModBlocks.getInstance().getDoor());
        output.accept((ItemLike)ModBlocks.getInstance().getPanel());
        output.accept((ItemLike)ModBlocks.getInstance().getPost());
        output.accept((ItemLike)ModBlocks.getInstance().getFancyDoor());
        output.accept((ItemLike)ModBlocks.getInstance().getFancyTrapdoor());
        output.accept((ItemLike)ModBlocks.getInstance().getDynamicTimberFrame());
    })).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXTRA_BLOCKS = TAB_REG.register("extra_blocks", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{GENERAL.getId()}).icon(() -> new ItemStack((ItemLike)ModBlocks.getInstance().getExtraTopBlocks().get(0))).title((Component)Component.translatable((String)"itemGroup.domum_ornamentum.extra-blocks")).displayItems((CreativeModeTab.DisplayItemsGenerator)new OutputAwareGenerator((config, output) -> {
        ModBlocks.getInstance().getExtraTopBlocks().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        ModBlocks.getInstance().getBricks().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        output.accept((ItemLike)ModBlocks.getInstance().getStandingBarrel());
        output.accept((ItemLike)ModBlocks.getInstance().getLayingBarrel());
    })).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> FLOATING_CARPETS = TAB_REG.register("floating_carpets", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{EXTRA_BLOCKS.getId()}).icon(() -> new ItemStack((ItemLike)ModBlocks.getInstance().getFloatingCarpets().get(0))).title((Component)Component.translatable((String)"itemGroup.domum_ornamentum.floating-carpets")).displayItems((CreativeModeTab.DisplayItemsGenerator)new OutputAwareGenerator((config, output) -> ModBlocks.getInstance().getFloatingCarpets().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0)))).build());

    private record OutputAwareGenerator(CreativeModeTab.DisplayItemsGenerator delegate) implements CreativeModeTab.DisplayItemsGenerator
    {
        public void accept(@NotNull CreativeModeTab.ItemDisplayParameters featureFlagSet, @NotNull CreativeModeTab.Output output) {
            this.delegate.accept(featureFlagSet, (CreativeModeTab.Output)new Output(output));
        }

        private record Output(CreativeModeTab.Output delegate) implements CreativeModeTab.Output
        {
            public void accept(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull CreativeModeTab.TabVisibility visibility) {
                this.delegate.accept(stack, visibility);
            }

            public void accept(@NotNull ItemLike itemLike) {
                if (itemLike instanceof ICachedItemGroupBlock) {
                    ICachedItemGroupBlock cachedItemGroupBlock = (ICachedItemGroupBlock)itemLike;
                    NonNullList stacks = NonNullList.create();
                    cachedItemGroupBlock.fillItemCategory((NonNullList<ItemStack>)stacks);
                    stacks.forEach(arg_0 -> ((CreativeModeTab.Output)this.delegate).accept(arg_0));
                } else {
                    this.delegate.accept(itemLike);
                }
            }
        }
    }
}

