/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.items.tools.MemoryCardItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAETags;
import net.pedroksl.advanced_ae.datagen.AAEConventionTags;
import net.pedroksl.advanced_ae.datagen.AAELanguageProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AAETagProvider {

    public static class AAEDataComponentTypeTagProvider
    extends TagsProvider<DataComponentType<?>> {
        private final AAELanguageProvider localization;
        private final HashSet<DataComponentType<?>> translated = new HashSet();

        public AAEDataComponentTypeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, @Nullable ExistingFileHelper existingFileHelper, AAELanguageProvider localization) {
            super(output, Registries.DATA_COMPONENT_TYPE, registries, "ae2", existingFileHelper);
            this.localization = localization;
        }

        protected void addTags(HolderLookup.Provider registries) {
            IdentityHashMap<DataComponentType, ResourceKey> componentKeys = new IdentityHashMap<DataComponentType, ResourceKey>();
            for (DeferredHolder entry : AAEComponents.DR.getEntries()) {
                componentKeys.put((DataComponentType)entry.get(), entry.getKey());
            }
            this.addExportedComponentCategory("Allowed Sides", AAEComponents.EXPORTED_ALLOWED_SIDES);
        }

        private void addExportedComponentCategory(String englishCategoryName, DataComponentType<?> ... types) {
            for (DataComponentType<?> type : types) {
                this.translated.add(type);
                ResourceKey key = (ResourceKey)BuiltInRegistries.DATA_COMPONENT_TYPE.getResourceKey(type).get();
                this.tag(ConventionTags.EXPORTED_SETTINGS).add(key);
                this.localization.add(MemoryCardItem.getSettingTranslationKey(type), englishCategoryName);
            }
        }
    }

    public static class AAEItemTagProvider
    extends ItemTagsProvider {
        public AAEItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, ExistingFileHelper existing) {
            super(output, registries, blockTags, "advanced_ae", existing);
        }

        protected void addTags(@NotNull HolderLookup.Provider provider) {
            this.tag(AAETags.ADV_PATTERN_PROVIDER).add((Object[])new Item[]{AAEBlocks.ADV_PATTERN_PROVIDER.asItem(), AAEItems.ADV_PATTERN_PROVIDER.asItem(), AAEBlocks.SMALL_ADV_PATTERN_PROVIDER.asItem(), AAEItems.SMALL_ADV_PATTERN_PROVIDER.asItem()});
            this.tag(ConventionTags.PATTERN_PROVIDER).add((Object[])new Item[]{AAEBlocks.ADV_PATTERN_PROVIDER.asItem(), AAEItems.ADV_PATTERN_PROVIDER.asItem(), AAEBlocks.SMALL_ADV_PATTERN_PROVIDER.asItem(), AAEItems.SMALL_ADV_PATTERN_PROVIDER.asItem()});
            this.tag(AAEConventionTags.ENCODER_CURIO).add((Object)AAEItems.ADV_PATTERN_ENCODER.asItem());
            this.tag(ConventionTags.WRENCH).add((Object)AAEItems.MONITOR_CONFIGURATOR.asItem());
            this.tag(Tags.Items.INGOTS).add((Object)AAEItems.QUANTUM_ALLOY.asItem());
            this.tag(Tags.Items.ARMORS).add((Object[])new Item[]{AAEItems.QUANTUM_HELMET.asItem(), AAEItems.QUANTUM_CHESTPLATE.asItem(), AAEItems.QUANTUM_LEGGINGS.asItem(), AAEItems.QUANTUM_BOOTS.asItem()});
            this.tag(ItemTags.HEAD_ARMOR).add((Object)AAEItems.QUANTUM_HELMET.asItem());
            this.tag(ItemTags.CHEST_ARMOR).add((Object)AAEItems.QUANTUM_CHESTPLATE.asItem());
            this.tag(ItemTags.LEG_ARMOR).add((Object)AAEItems.QUANTUM_LEGGINGS.asItem());
            this.tag(ItemTags.FOOT_ARMOR).add((Object)AAEItems.QUANTUM_BOOTS.asItem());
            this.tag(Tags.Items.BUCKETS).add((Object)AAEFluids.QUANTUM_INFUSION.bucketItem());
            this.tag(Tags.Items.DUSTS).add((Object)AAEItems.QUANTUM_INFUSED_DUST.asItem());
            this.tag(AAEConventionTags.SHATTERED_SINGULARITY).add((Object)AAEItems.QUANTUM_INFUSED_DUST.asItem());
            this.tag(AAEConventionTags.QUANTUM_ALLOY_PLATE).add((Object)AAEItems.QUANTUM_ALLOY_PLATE.asItem());
            this.tag(AAEConventionTags.PLATES).addTag(AAEConventionTags.QUANTUM_ALLOY_PLATE);
            this.tag(AAEConventionTags.QUANTUM_ALLOY_STORAGE_BLOCK_ITEM).add((Object)AAEBlocks.QUANTUM_ALLOY_BLOCK.asItem());
            this.tag(Tags.Items.STORAGE_BLOCKS).addTag(AAEConventionTags.QUANTUM_ALLOY_STORAGE_BLOCK_ITEM);
            this.tag(ItemTags.STAIRS).add((Object)AAEBlocks.QUANTUM_ALLOY_STAIRS.asItem());
            this.tag(ItemTags.SLABS).add((Object)AAEBlocks.QUANTUM_ALLOY_SLAB.asItem());
        }

        @NotNull
        public String getName() {
            return "Tags (Item)";
        }
    }

    public static class AAEBlockTagProvider
    extends IntrinsicHolderTagsProvider<Block> {
        private static final BlockDefinition<?>[] QUANTUM_ALLOY_BLOCKS = new BlockDefinition[]{AAEBlocks.QUANTUM_ALLOY_BLOCK, AAEBlocks.QUANTUM_ALLOY_SLAB, AAEBlocks.QUANTUM_ALLOY_WALL, AAEBlocks.QUANTUM_ALLOY_STAIRS};

        public AAEBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.BLOCK, registries, block -> (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(block).orElseThrow(), "advanced_ae", existingFileHelper);
        }

        protected void addTags(@NotNull HolderLookup.Provider provider) {
            HashMap specialTags = new HashMap();
            for (BlockDefinition<?> skyStoneBlock : QUANTUM_ALLOY_BLOCKS) {
                specialTags.put(skyStoneBlock, List.of(BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_IRON_TOOL));
            }
            List<TagKey> defaultTags = List.of(BlockTags.MINEABLE_WITH_PICKAXE);
            for (BlockDefinition<?> block : AAEBlocks.getBlocks()) {
                for (TagKey desiredTag : specialTags.getOrDefault(block, defaultTags)) {
                    this.tag(desiredTag).add((Object)block.block());
                }
            }
            this.tag(AAEConventionTags.QUANTUM_ALLOY_STORAGE_BLOCK_BLOCK).add((Object)AAEBlocks.QUANTUM_ALLOY_BLOCK.block());
            this.tag(Tags.Blocks.STORAGE_BLOCKS).addTag(AAEConventionTags.QUANTUM_ALLOY_STORAGE_BLOCK_BLOCK);
            this.tag(BlockTags.WALLS).add((Object)AAEBlocks.QUANTUM_ALLOY_WALL.block());
            this.tag(BlockTags.STAIRS).add((Object)AAEBlocks.QUANTUM_ALLOY_STAIRS.block());
            this.tag(BlockTags.SLABS).add((Object)AAEBlocks.QUANTUM_ALLOY_SLAB.block());
        }

        @NotNull
        public String getName() {
            return "Tags (Block)";
        }
    }
}

