/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import plus.dragons.createenchantmentindustry.client.ponder.CEIPonderPlugin;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;
import plus.dragons.createenchantmentindustry.data.CEIGenerateEntriesProvider;
import plus.dragons.createenchantmentindustry.data.CEIRecipeProvider;

@Mod(value="create_enchantment_industry")
public class CEIData {
    public CEIData(IEventBus modBus) {
        if (!DatagenModLoader.isRunningDataGen()) {
            return;
        }
        CEICommon.REGISTRATE.registerBuiltinLocalization("interface");
        CEICommon.REGISTRATE.registerForeignLocalization();
        CEICommon.REGISTRATE.registerPonderLocalization(CEIPonderPlugin::new);
        CEICommon.REGISTRATE.registerExtraLocalization(CEIAdvancements::provideLang);
        modBus.register((Object)this);
    }

    @SubscribeEvent
    public void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput output = generator.getPackOutput();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        CEIGenerateEntriesProvider generatedEntriesProvider = new CEIGenerateEntriesProvider(output, lookupProvider);
        lookupProvider = generatedEntriesProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)generatedEntriesProvider);
        generator.addProvider(server, (DataProvider)new CEIRecipeProvider(output, lookupProvider));
        generator.addProvider(server, (DataProvider)new CEIAdvancements(output, lookupProvider));
    }
}

