/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGTags;

public enum UGItemTiers implements Tier
{
    CLOGGRUM(286, 6.0f, 3.0f, 8, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.CLOGGRUM_INGOT.get()}), (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL),
    FROSTSTEEL(575, 7.0f, 2.0f, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FROSTSTEEL_INGOT.get()}), (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL),
    UTHERIUM(1279, 8.5f, 3.5f, 17, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UTHERIUM_CRYSTAL.get()}), (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL),
    FORGOTTEN(1876, 8.0f, 3.0f, 2, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_INGOT.get()}), UGTags.Blocks.INCORRECT_FOR_FORGOTTEN_TOOL);

    private final int durability;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;
    private final TagKey<Block> incorrectTag;

    private UGItemTiers(int durability, float speed, float damage, int enchantmentValue, Supplier<Ingredient> repairIngredient, TagKey<Block> incorrectTag) {
        this.durability = durability;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
        this.incorrectTag = incorrectTag;
    }

    public int getUses() {
        return this.durability;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectTag;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

