/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class UGDamageSources {
    public static final ResourceKey<DamageType> DEPTHROCK_PEBBLE = UGDamageSources.create("depthrock_pebble");
    public static final ResourceKey<DamageType> GOO_BALL = UGDamageSources.create("goo_ball");
    public static final ResourceKey<DamageType> BLISTERBERRY_BUSH = UGDamageSources.create("blisterberry_bush");
    public static final ResourceKey<DamageType> SHARD_TORCH = UGDamageSources.create("shard_torch");
    public static final ResourceKey<DamageType> UTHERIC_INFECTION = UGDamageSources.create("utheric_infection");

    public static ResourceKey<DamageType> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name));
    }

    public static DamageSource getShardTorchDamage(Level level, @NotNull Vec3 position) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(SHARD_TORCH), position);
    }

    public static void bootstrap(BootstrapContext<DamageType> context) {
        context.register(DEPTHROCK_PEBBLE, (Object)new DamageType("arrow", 0.1f));
        context.register(GOO_BALL, (Object)new DamageType("arrow", 0.1f));
        context.register(BLISTERBERRY_BUSH, (Object)new DamageType("blisterberry_bush", 0.1f, DamageEffects.POKING));
        context.register(SHARD_TORCH, (Object)new DamageType("shard_torch", DamageScaling.ALWAYS, 0.1f));
        context.register(UTHERIC_INFECTION, (Object)new DamageType("utheric_infection", DamageScaling.ALWAYS, 0.0f));
    }
}

