/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.bucket;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import quek.undergarden.item.bucket.UGBucketItem;
import quek.undergarden.registry.UGDataComponents;

public class BucketDispenseBehavior
extends OptionalDispenseItemBehavior {
    private final DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior();

    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos pos = source.pos().relative(facing);
        BlockState state = level.getBlockState(pos);
        if (UGBucketItem.isBucketEmpty(stack)) {
            return this.fillBucket(source, stack, level, pos, facing, state);
        }
        return this.emptyBucket(source, stack, level, pos, facing);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ItemStack fillBucket(BlockSource source, ItemStack stack, ServerLevel level, BlockPos pos, Direction facing, BlockState state) {
        Block block;
        if (!UGBucketItem.containsBlock(stack) && (block = state.getBlock()) instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            if (!(state.getBlock() instanceof LiquidBlock)) {
                ItemStack resultStack = bucketPickup.pickupBlock(null, (LevelAccessor)level, pos, state);
                if (resultStack.isEmpty()) return stack;
                ItemStack usedStack = stack.copy();
                usedStack.setCount(1);
                usedStack.set(UGDataComponents.STORED_BLOCK, (Object)state);
                if (stack.getCount() != 1) return this.consumeWithRemainder(source, stack, usedStack);
                return usedStack;
            }
        }
        FluidActionResult action = FluidUtil.tryPickUpFluid((ItemStack)stack.copyWithCount(1), null, (Level)level, (BlockPos)pos, (Direction)facing.getOpposite());
        ItemStack resultStack = action.getResult();
        if (!action.isSuccess() || resultStack.isEmpty()) return stack;
        if (stack.getCount() != 1) return this.consumeWithRemainder(source, stack, resultStack);
        return resultStack;
    }

    private ItemStack emptyBucket(BlockSource source, ItemStack stack, ServerLevel level, BlockPos pos, Direction facing) {
        Item dispensibleContainerItem2;
        if (UGBucketItem.containsBlock(stack)) {
            Item item;
            BlockState block = (BlockState)stack.get(UGDataComponents.STORED_BLOCK);
            if (block != null && (item = block.getBlock().asItem()) instanceof DispensibleContainerItem) {
                DispensibleContainerItem dispensibleContainerItem2 = (DispensibleContainerItem)item;
                if (dispensibleContainerItem2.emptyContents(null, (Level)level, pos, null, stack)) {
                    dispensibleContainerItem2.checkExtraContent(null, (Level)level, stack, pos);
                    ItemStack workBucket = stack.copy();
                    workBucket.remove(UGDataComponents.STORED_BLOCK);
                    return workBucket;
                }
                return this.dispenseBehavior.dispense(source, stack);
            }
        } else if (UGBucketItem.getBucketedEntity(stack).isPresent() && (dispensibleContainerItem2 = stack.getItem()) instanceof UGBucketItem) {
            UGBucketItem bucketItem = (UGBucketItem)dispensibleContainerItem2;
            if (UGBucketItem.hasFluid(stack)) {
                ItemStack workBucket = stack.copy();
                workBucket.remove(DataComponents.BUCKET_ENTITY_DATA);
                ItemStack fluidResult = this.dispenseFluid(source, workBucket, level, pos);
                bucketItem.spawnEntityFromBucket(null, (Level)source.level(), stack, pos, true);
                return fluidResult;
            }
            return bucketItem.spawnEntityFromBucket(null, (Level)source.level(), stack, pos, true);
        }
        return this.dispenseFluid(source, stack, level, pos);
    }

    private ItemStack dispenseFluid(BlockSource source, ItemStack stack, ServerLevel level, BlockPos pos) {
        FluidActionResult result;
        ItemStack singleStack = stack.copyWithCount(1);
        Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)singleStack);
        if (fluidHandler.isEmpty()) {
            return super.execute(source, stack);
        }
        FluidStack fluidStack = ((IFluidHandlerItem)fluidHandler.get()).drain(1000, IFluidHandler.FluidAction.EXECUTE);
        FluidActionResult fluidActionResult = result = !fluidStack.isEmpty() ? FluidUtil.tryPlaceFluid(null, (Level)level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (ItemStack)stack, (FluidStack)fluidStack) : FluidActionResult.FAILURE;
        if (result.isSuccess()) {
            ItemStack drainedStack = result.getResult();
            if (drainedStack.getCount() == 1) {
                return drainedStack;
            }
            if (!drainedStack.isEmpty() && !source.blockEntity().insertItem(drainedStack).isEmpty()) {
                this.dispense(source, drainedStack);
            }
            drainedStack.shrink(1);
            return drainedStack;
        }
        return this.dispense(source, stack);
    }
}

