/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class UGItemModelProvider
extends ItemModelProvider {
    public UGItemModelProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, "undergarden", fileHelper);
    }

    private String blockName(Supplier<? extends Block> block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath();
    }

    private ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public void itemFence(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", "block/" + name);
    }

    public void block(Supplier<? extends Block> block) {
        this.block(block, this.blockName(block));
    }

    public void block(Supplier<? extends Block> block, String name) {
        this.withExistingParent(this.blockName(block), this.modLoc("block/" + name));
    }

    public void blockFlat(Supplier<? extends Block> block) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + this.blockName(block)));
    }

    public void blockFlatWithBlockTexture(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + name))).renderType("translucent");
    }

    public void blockFlatWithItemTexture(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    public void normalItem(Supplier<? extends Item> item) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath()));
    }

    public void normalItemSpecifiedTexture(Supplier<? extends Item> item, String name) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    public void torchItem(Supplier<? extends Block> item) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath()));
    }

    public void toolItem(Supplier<? extends Item> item) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath()));
    }

    public void rodItem(Supplier<? extends Item> item) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), this.mcLoc("item/handheld_rod"))).texture("layer0", this.modLoc("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath()));
    }

    public void egg(Supplier<? extends Item> item) {
        this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), this.mcLoc("item/template_spawn_egg"));
    }

    public void sign(Supplier<? extends SignBlock> sign) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(sign), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + this.blockName(sign)));
    }

    public void wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        this.wallInventory(BuiltInRegistries.BLOCK.getKey((Object)((Block)wall.get())).getPath(), this.texture(this.blockName(fullBlock)));
    }

    public void button(Supplier<? extends ButtonBlock> button, Supplier<? extends Block> fullBlock) {
        this.buttonInventory(BuiltInRegistries.BLOCK.getKey((Object)((Block)button.get())).getPath(), this.texture(this.blockName(fullBlock)));
    }

    public void trapdoor(Supplier<? extends TrapDoorBlock> trapdoor) {
        this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)((Block)trapdoor.get())).getPath(), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)("block/" + this.blockName(trapdoor) + "_bottom")));
    }
}

