/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import quek.undergarden.client.model.Denizen2Model;
import quek.undergarden.client.model.DenizenModel;
import quek.undergarden.client.model.FixedHumanoidModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.layer.DenizenEyesLayer;
import quek.undergarden.entity.monster.denizen.Denizen;

public class DenizenRenderer
extends HumanoidMobRenderer<Denizen, FixedHumanoidModel<Denizen>> {
    private final FixedHumanoidModel<Denizen> shortModel = (FixedHumanoidModel)this.getModel();
    private final FixedHumanoidModel<Denizen> tallModel;

    public DenizenRenderer(EntityRendererProvider.Context context) {
        super(context, new DenizenModel(context.bakeLayer(UGModelLayers.DENIZEN)), 0.5f);
        this.tallModel = new Denizen2Model<Denizen>(context.bakeLayer(UGModelLayers.DENIZEN_2));
        this.addLayer(new DenizenEyesLayer(this));
    }

    public ResourceLocation getTextureLocation(Denizen entity) {
        return switch (entity.getVariant()) {
            default -> throw new MatchException(null, null);
            case Denizen.Type.SHORT -> ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/entity/denizen.png");
            case Denizen.Type.TALL -> ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/entity/denizen2.png");
        };
    }

    public void render(Denizen entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        switch (entity.getVariant()) {
            case SHORT: {
                this.model = this.shortModel;
                break;
            }
            case TALL: {
                this.model = this.tallModel;
            }
        }
        super.render((LivingEntity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void setupRotations(Denizen denizen, PoseStack stack, float ageInTicks, float yRot, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)denizen, stack, ageInTicks, yRot, partialTicks, scale);
        if (denizen.hasPose(Pose.SITTING)) {
            stack.translate(0.0, denizen.getVariant() == Denizen.Type.TALL ? (double)-1.55f : (double)-0.65f, 0.0);
        }
    }
}

