/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.Gwib;

public class GwibModel<T extends Gwib>
extends ListModel<T> {
    private final ModelPart tail;
    private final ModelPart body;

    public GwibModel(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -2.0f, 10.0f, 5.0f, 13.0f, new CubeDeformation(0.01f)).texOffs(0, 14).addBox(0.0f, -11.0f, -6.0f, 0.0f, 5.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 18).addBox(-5.0f, -2.0f, -9.0f, 10.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition eastWhisker = head.addOrReplaceChild("eastWhisker", CubeListBuilder.create().texOffs(31, 38).addBox(-6.0f, 0.0f, -6.0f, 6.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)3.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition westWhisker = head.addOrReplaceChild("westWhisker", CubeListBuilder.create().texOffs(19, 38).addBox(0.0f, 0.0f, -6.0f, 6.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)3.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition eastFin = body.addOrReplaceChild("eastFin", CubeListBuilder.create().texOffs(27, 18).addBox(-9.0f, 0.0f, -5.5f, 9.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-5.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition westFin = body.addOrReplaceChild("westFin", CubeListBuilder.create().texOffs(22, 0).addBox(0.0f, 0.0f, -5.5f, 9.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-5.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 37).addBox(-3.0f, -1.0f, 0.0f, 6.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(30, 32).addBox(-6.0f, 0.0f, 8.0f, 12.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)11.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = headPitch * ((float)Math.PI / 180);
        this.body.yRot = netHeadYaw * ((float)Math.PI / 180);
        float f = 1.0f;
        if (!entity.isInWater()) {
            f = 1.5f;
        }
        this.tail.yRot = -f * 0.45f * Mth.sin((float)(0.6f * ageInTicks));
    }

    public Iterable<ModelPart> parts() {
        return ImmutableSet.of((Object)this.body);
    }
}

