/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.integration;

import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

public class CuriosMethods {
    public static void removeFluidStacksFromInventory(Player player, FluidStack fluidStack, boolean simulate) {
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player);
        curios.ifPresent(iCuriosItemHandler -> iCuriosItemHandler.getCurios().forEach((id, stackHandler) -> {
            for (int j = 0; j < stackHandler.getSlots(); ++j) {
                ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(j);
                BuildingUtils.checkItemForFluids(itemInSlot, fluidStack, simulate);
            }
        }));
    }

    public static void removeStacksFromInventory(Player player, ArrayList<ItemStack> testArray, boolean simulate) {
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player);
        curios.ifPresent(iCuriosItemHandler -> iCuriosItemHandler.getCurios().forEach((id, stackHandler) -> {
            for (int j = 0; j < stackHandler.getSlots(); ++j) {
                ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(j);
                IItemHandler itemStackCapability = (IItemHandler)itemInSlot.getCapability(Capabilities.ItemHandler.ITEM, null);
                if (itemStackCapability == null) continue;
                BuildingUtils.checkHandlerForItems(itemStackCapability, testArray, simulate);
                if (testArray.isEmpty()) break;
            }
        }));
    }

    public static void countItemStacks(Player player, ItemStack itemStack, int[] counter) {
        Optional curiosOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
        curiosOpt.ifPresent(iCuriosItemHandler -> iCuriosItemHandler.getCurios().forEach((id, stackHandler) -> {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(i);
                IItemHandler itemStackCapability = (IItemHandler)itemInSlot.getCapability(Capabilities.ItemHandler.ITEM, null);
                if (itemStackCapability == null) continue;
                for (int j = 0; j < itemStackCapability.getSlots(); ++j) {
                    ItemStack itemInBagSlot = itemStackCapability.getStackInSlot(j);
                    if (!ItemStack.isSameItem((ItemStack)itemInBagSlot, (ItemStack)itemStack)) continue;
                    counter[0] = counter[0] + itemInBagSlot.getCount();
                }
            }
        }));
    }

    public static void giveFluidToPlayer(Player player, FluidStack returnedFluid) {
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)player);
        curios.ifPresent(iCuriosItemHandler -> iCuriosItemHandler.getCurios().forEach((id, stackHandler) -> {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(i);
                BuildingUtils.insertFluidIntoItem(itemInSlot, returnedFluid, false);
                if (!returnedFluid.isEmpty()) continue;
                return;
            }
        }));
    }

    public static void giveItemToPlayer(Player player, ItemStack realReturnedItem) {
        Optional curiosOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
        curiosOpt.ifPresent(iCuriosItemHandler -> iCuriosItemHandler.getCurios().forEach((id, stackHandler) -> {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(i);
                IItemHandler itemStackCapability = (IItemHandler)itemInSlot.getCapability(Capabilities.ItemHandler.ITEM, null);
                if (itemStackCapability == null) continue;
                for (int j = 0; j < itemStackCapability.getSlots(); ++j) {
                    ItemStack itemInBagSlot = itemStackCapability.getStackInSlot(j);
                    if (ItemStack.isSameItem((ItemStack)itemInBagSlot, (ItemStack)realReturnedItem)) {
                        itemStackCapability.insertItem(j, realReturnedItem.split(itemStackCapability.getSlotLimit(j) - itemInBagSlot.getCount()), false);
                    }
                    if (!realReturnedItem.isEmpty()) continue;
                    return;
                }
            }
        }));
    }
}

