/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.particles.itemparticle;

import com.direwolf20.buildinggadgets2.client.particles.itemparticle.ItemFlowParticleData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ItemFlowParticle
extends BreakingItemParticle {
    private double targetX;
    private double targetY;
    private double targetZ;
    Random random = new Random();
    private float partSize;
    private boolean doGravity;
    private boolean shrinking;
    public static ParticleProvider<ItemFlowParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new ItemFlowParticle(world, x, y, z, data.getItemStack(), data.doGravity, data.shrinking);

    public ItemFlowParticle(ClientLevel world, double x, double y, double z, ItemStack itemStack, boolean gravity, boolean shrinking) {
        super(world, x, y, z, itemStack);
        this.doGravity = gravity;
        this.shrinking = shrinking;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        if (shrinking) {
            this.targetX = x + 1.75;
            this.targetY = y + 1.75;
            this.targetZ = z + 1.75;
        } else if (!gravity) {
            double randomX = this.random.nextFloat();
            double randomY = this.random.nextFloat();
            double randomZ = this.random.nextFloat();
            this.xo = x + randomX;
            this.yo = y + randomY;
            this.zo = z + randomZ;
            this.setPos(this.xo, this.yo, this.zo);
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
        }
        Vec3 target = new Vec3(this.targetX, this.targetY, this.targetZ);
        Vec3 source = new Vec3(this.x, this.y, this.z);
        Vec3 path = target.subtract(source).normalize().multiply(1.0, 1.0, 1.0);
        float minSize = 0.25f;
        float maxSize = 0.5f;
        this.partSize = minSize + this.random.nextFloat() * (maxSize - minSize);
        float speedModifier = 0.5f * (this.partSize - minSize) / (maxSize - minSize) + 0.25f;
        int ticksPerBlock = 15;
        float speedAdjust = (float)ticksPerBlock * (1.0f / speedModifier);
        this.xd += path.x / (double)speedAdjust;
        this.yd += path.y / (double)speedAdjust;
        this.zd += path.z / (double)speedAdjust;
        this.lifetime = 30;
        int longLifeChance = this.random.nextInt(20);
        if (longLifeChance == 0) {
            this.lifetime = 120;
        }
        this.scale(this.partSize);
        this.partSize = this.quadSize;
        if (this.sprite == null) {
            this.setSprite(Minecraft.getInstance().getItemRenderer().getModel(new ItemStack((ItemLike)Blocks.COBBLESTONE), (Level)world, (LivingEntity)null, 0).getParticleIcon());
        }
        if (gravity) {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
            this.gravity = 0.0625f;
            this.hasPhysics = true;
            this.age = this.lifetime / 2;
            this.scale(2.0f);
            this.partSize = this.quadSize;
            this.updateColorAndGravity();
        } else {
            this.gravity = 0.0f;
            this.hasPhysics = false;
        }
        if (!shrinking) {
            this.updateColorAndGravity();
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
        }
        if (!this.shrinking && this.y <= this.targetY) {
            this.remove();
        }
        this.updateColorAndGravity();
    }

    public void updateColorAndGravity() {
        float relativeAge = (float)(this.lifetime - this.age) / (float)this.lifetime;
        float shrink = Mth.lerp((float)relativeAge, (float)0.1f, (float)1.0f);
        this.quadSize = this.partSize * shrink;
        float adjustedAge = (float)Math.pow(relativeAge, 2.0);
        float darkness = this.shrinking ? Mth.lerp((float)adjustedAge, (float)0.0f, (float)1.0f) : Mth.lerp((float)adjustedAge, (float)1.0f, (float)0.15f);
        this.rCol = darkness;
        this.gCol = darkness;
        this.bCol = darkness;
        if (relativeAge < 0.5f) {
            adjustedAge = (float)Math.pow(relativeAge / 0.5f, 2.0);
            this.alpha = this.shrinking ? Mth.lerp((float)adjustedAge, (float)0.4f, (float)1.0f) : Mth.lerp((float)adjustedAge, (float)1.0f, (float)0.2f);
        }
        if (!this.doGravity) {
            int gravityChance = this.random.nextInt(2);
            if (relativeAge < 0.75f && gravityChance == 0) {
                this.gravity = 0.05f;
            }
        }
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF00080;
    }
}

