/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.armor;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.client.renderers.ExosuitArmorRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.item.tools.armor.BaseJetpackItem;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class JetpackItem
extends ArmorItem
implements GeoItem,
BaseJetpackItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static long LAST_GROUND_CONTACT = Long.MAX_VALUE;
    public static boolean PRESSED_SPACE = false;

    public JetpackItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (world.isClientSide) {
            this.tickJetpack(stack, entity, world);
        }
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return this.getJetpackBarColor(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getJetpackBarStep(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        MutableComponent hint = Component.translatable((String)"tooltip.oritech.jetpack_usage").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
        tooltip.add((Component)hint);
        hint = Component.translatable((String)"tooltip.oritech.jetpack_usage2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
        tooltip.add((Component)hint);
        this.addJetpackTooltip(stack, tooltip, true);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GeoArmorRenderer<?> renderer;

            @Nullable
            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new ExosuitArmorRenderer(Oritech.id("armor/basic_jetpack"), Oritech.id("armor/basic_jetpack"));
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 20, state -> PlayState.STOP));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean requireUpward() {
        return true;
    }

    @Override
    public float getSpeed() {
        return Oritech.CONFIG.basicJetpack.speed();
    }

    @Override
    public int getRfUsage() {
        return Oritech.CONFIG.basicJetpack.energyUsage();
    }

    @Override
    public int getFuelUsage() {
        return Oritech.CONFIG.basicJetpack.fuelUsage();
    }

    @Override
    public long getFuelCapacity() {
        return Oritech.CONFIG.basicJetpack.fuelCapacity();
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return Oritech.CONFIG.basicJetpack.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(ItemStack stack) {
        return Oritech.CONFIG.basicJetpack.chargeSpeed();
    }

    public static void receiveUsagePacket(JetpackUsageUpdatePacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!(stack.getItem() instanceof BaseJetpackItem)) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        serverPlayer.connection.aboveGroundTickCount = 0;
        stack.set(EnergyApi.ITEM.getEnergyComponent(), (Object)packet.energyStored);
        if (packet.fluidAmount > 0L) {
            stack.set(ComponentContent.STORED_FLUID.get(), (Object)FluidStack.create((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)packet.fluidType))), (long)packet.fluidAmount));
        }
    }

    public record JetpackUsageUpdatePacket(long energyStored, String fluidType, long fluidAmount) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<JetpackUsageUpdatePacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("jetpack_use"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

