/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import rearth.oritech.block.entity.arcane.SpawnerControllerBlockEntity;
import rearth.oritech.client.renderers.LaserArmRenderer;

public class SpawnerControllerRenderer
implements BlockEntityRenderer<SpawnerControllerBlockEntity> {
    public void render(SpawnerControllerBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.renderedEntity != null && entity.hasCage) {
            matrices.pushPose();
            matrices.translate(0.0f, (float)(-Math.round(entity.spawnedMob.getHeight() + 0.4f)), 0.0f);
            matrices.mulPose(Axis.YP.rotationDegrees(45.0f));
            EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            EntityRenderer renderer = dispatcher.getRenderer(entity.renderedEntity);
            float progress = Math.min(1.0f, (float)entity.collectedSouls / (float)entity.maxSouls);
            if (progress != 0.0f) {
                progress = (float)LaserArmRenderer.lerp(entity.lastProgress, progress, (double)0.03f);
            }
            entity.lastProgress = progress;
            int color = FastColor.ARGB32.color((int)((int)(75.0f + 180.0f * progress)), (int)((int)(255.0f * (1.0f - progress))), (int)255, (int)255);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
                if (entity.renderedEntity instanceof LivingEntity) {
                    matrices.scale(-1.0f, -1.0f, 1.0f);
                    matrices.translate(0.0f, -1.501f, 0.0f);
                    matrices.scale(0.9f, 0.9f, 0.9f);
                    EntityModel model = livingEntityRenderer.getModel();
                    RenderType renderLayer = RenderType.beaconBeam((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png"), (boolean)true);
                    VertexConsumer vertexConsumer = vertexConsumers.getBuffer(renderLayer);
                    model.renderToBuffer(matrices, vertexConsumer, light, overlay, color);
                }
            }
            matrices.popPose();
        }
    }
}

