/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.reactor;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.block.blocks.reactor.NuclearExplosionBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;

public class NuclearExplosionEntity
extends BlockEntity
implements BlockEntityTicker<NuclearExplosionEntity> {
    private long startTime = -1L;
    private final Set<BlockPos> removedBlocks = new HashSet<BlockPos>();
    private final Set<BlockPos> borderBlocks = new HashSet<BlockPos>();
    private final Set<DirectionExplosionWave> waves = new HashSet<DirectionExplosionWave>();
    private final int size;

    public NuclearExplosionEntity(BlockPos pos, BlockState state, int size) {
        super(BlockEntitiesContent.REACTOR_EXPLOSION_ENTITY, pos, state);
        this.size = size;
    }

    public NuclearExplosionEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.REACTOR_EXPLOSION_ENTITY, pos, state);
        this.size = 9;
    }

    public void tick(Level world, BlockPos pos, BlockState state, NuclearExplosionEntity blockEntity) {
        long age;
        if (world.isClientSide) {
            return;
        }
        int initialRadius = this.size;
        if (this.startTime == -1L) {
            this.startTime = world.getGameTime();
            this.explosionSphere(initialRadius + 7, 200, pos);
            world.playSound(null, pos, SoundContent.NUKE_EXPLOSION, SoundSource.BLOCKS, 30.0f, 1.0f);
        }
        if ((age = world.getGameTime() - this.startTime) == 1L) {
            this.createExplosionWaves(initialRadius);
        }
        if (age > 1L) {
            this.waves.forEach(DirectionExplosionWave::nextGeneration);
            this.processBorderBlocks(initialRadius * initialRadius);
        }
        if (age > (long)(initialRadius * 2)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    private void createExplosionWaves(int initialRadius) {
        int rayCount = initialRadius / 2 + 3;
        List<Vec3> directions = this.getRandomRayDirections(rayCount);
        for (Vec3 direction : directions) {
            DirectionExplosionWave data = new DirectionExplosionWave(initialRadius, this.addRandomOffset(direction, 0.15f), this.worldPosition.offset(0, this.level.random.nextIntBetweenInclusive(-initialRadius / 2, initialRadius / 2), 0).immutable());
            this.waves.add(data);
        }
    }

    private void processBorderBlocks(int maxDist) {
        this.borderBlocks.forEach(target -> {
            if (this.removedBlocks.contains(target)) {
                return;
            }
            double distSq = target.distSqr((Vec3i)this.worldPosition);
            BlockState targetBlock = this.level.getBlockState(target);
            double percentageDist = distSq / (double)(maxDist * maxDist) * 8.0;
            double percentageVaried = percentageDist * ((double)this.level.random.nextFloat() * 0.6 - 0.3 + 1.0);
            if (Platform.isModLoaded((String)"ftbchunks")) {
                boolean isClaimed;
                boolean bl = isClaimed = FTBChunksAPI.api().getManager().getChunk(new ChunkDimPos(this.level, target)) != null;
                if (isClaimed) {
                    return;
                }
            }
            boolean replaced = false;
            BlockState replacementState = Blocks.AIR.defaultBlockState();
            if (targetBlock.is(BlockTags.LOGS)) {
                replaced = true;
                BlockState blockState = replacementState = (double)this.level.random.nextFloat() < 0.8 ? Blocks.BASALT.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState();
                if (percentageVaried < (double)0.4f) {
                    replacementState = Blocks.AIR.defaultBlockState();
                }
            } else if (targetBlock.is(BlockTags.LEAVES)) {
                replaced = true;
                BlockState blockState = replacementState = (double)this.level.random.nextFloat() > 0.4 ? Blocks.MANGROVE_ROOTS.defaultBlockState() : Blocks.AIR.defaultBlockState();
                if (percentageVaried < (double)0.6f) {
                    replacementState = Blocks.AIR.defaultBlockState();
                }
            } else if (targetBlock.is(BlockTags.SAPLINGS) || targetBlock.is(Blocks.SHORT_GRASS)) {
                replaced = true;
                BlockState blockState = replacementState = (double)this.level.random.nextFloat() > 0.4 ? Blocks.DEAD_BUSH.defaultBlockState() : Blocks.AIR.defaultBlockState();
                if (percentageVaried < 0.5) {
                    replacementState = Blocks.AIR.defaultBlockState();
                }
            } else if (targetBlock.is(Blocks.GRASS_BLOCK)) {
                replaced = true;
                replacementState = percentageVaried < 0.05 ? ((double)this.level.random.nextFloat() > 0.5 ? Blocks.TUFF.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState()) : (percentageVaried < 0.3 ? ((double)this.level.random.nextFloat() > 0.2 ? Blocks.TUFF.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState()) : (percentageVaried < 0.55 ? ((double)this.level.random.nextFloat() > 0.1 ? Blocks.COARSE_DIRT.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState()) : Blocks.DIRT.defaultBlockState()));
                if ((double)this.level.random.nextFloat() > 0.7) {
                    replaced = false;
                }
            } else if (targetBlock.is(Blocks.DIRT)) {
                replaced = true;
                if (percentageVaried < 0.15) {
                    replacementState = (double)this.level.random.nextFloat() > 0.6 ? Blocks.COARSE_DIRT.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState();
                } else if (percentageVaried < 0.3) {
                    replacementState = (double)this.level.random.nextFloat() > 0.3 ? Blocks.TUFF.defaultBlockState() : Blocks.COARSE_DIRT.defaultBlockState();
                } else if (percentageVaried < 0.65) {
                    replacementState = (double)this.level.random.nextFloat() > 0.2 ? Blocks.COARSE_DIRT.defaultBlockState() : Blocks.TUFF.defaultBlockState();
                } else {
                    replaced = false;
                }
                if ((double)this.level.random.nextFloat() > 0.1) {
                    replaced = false;
                }
            } else if (targetBlock.is(BlockTags.BASE_STONE_OVERWORLD)) {
                replaced = true;
                if (percentageVaried < 0.3) {
                    replacementState = (double)this.level.random.nextFloat() > 0.5 ? Blocks.DEEPSLATE.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState();
                } else if (percentageVaried < 0.5) {
                    replacementState = (double)this.level.random.nextFloat() > 0.3 ? Blocks.STONE.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState();
                } else if (percentageVaried < 0.7) {
                    replacementState = (double)this.level.random.nextFloat() > 0.2 ? Blocks.GRANITE.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState();
                } else {
                    replaced = false;
                }
            } else if (targetBlock.is(BlockTags.SAND) || targetBlock.is(Blocks.SANDSTONE)) {
                replaced = true;
                replacementState = percentageVaried < 0.2 ? ((double)this.level.random.nextFloat() > 0.7 ? Blocks.SANDSTONE.defaultBlockState() : Blocks.MAGMA_BLOCK.defaultBlockState()) : Blocks.GLASS.defaultBlockState();
                if (percentageVaried > 0.8) {
                    replaced = false;
                }
            }
            if (replaced) {
                this.level.setBlock(target, replacementState, 34, 1);
                if (this.level.getBlockState(target.above()).canBeReplaced() && (double)this.level.random.nextFloat() > 0.97) {
                    this.level.setBlock(target.above(), Blocks.FIRE.defaultBlockState(), 34, 0);
                }
            }
        });
        this.borderBlocks.clear();
    }

    private void collectExtraEdgeBlocks(BlockPos center) {
        BlockPos.betweenClosed((BlockPos)center.offset(-8, -8, -8), (BlockPos)center.offset(8, 8, 8)).forEach(target -> {
            if (this.removedBlocks.contains(target)) {
                return;
            }
            BlockState targetState = this.level.getBlockState(target);
            if (targetState.isAir()) {
                return;
            }
            this.borderBlocks.add(target.immutable());
        });
    }

    private int explosionSphere(int radius, int power, BlockPos pos) {
        int radiusSq = radius * radius;
        int radiusSqExtra = (radius + 3) * (radius + 3);
        int usedPower = 0;
        int hardBusters = radius;
        for (BlockPos target : BlockPos.withinManhattan((BlockPos)pos, (int)(radius + 3), (int)(radius + 3), (int)(radius + 3))) {
            if (this.removedBlocks.contains(target)) continue;
            double distSq = target.distSqr((Vec3i)pos);
            if (distSq > (double)radiusSq) {
                if (!(distSq <= (double)radiusSqExtra)) continue;
                this.borderBlocks.add(target.immutable());
                continue;
            }
            double removalPercentage = (distSq - (double)((float)radiusSq / 2.0f)) / (double)radiusSq;
            if ((double)this.level.random.nextFloat() < removalPercentage - 0.2) {
                this.borderBlocks.add(target.immutable());
                continue;
            }
            BlockState targetState = this.level.getBlockState(target);
            Block targetBlock = targetState.getBlock();
            float targetHardness = targetBlock.getExplosionResistance();
            if (targetBlock instanceof NuclearExplosionBlock || targetState.isAir() || targetState.getDestroySpeed((BlockGetter)this.level, target) < 0.0f || targetHardness > (float)power && hardBusters-- < 0) continue;
            usedPower = (int)((float)usedPower + targetHardness);
            if (Platform.isModLoaded((String)"ftbchunks")) {
                boolean isClaimed;
                boolean bl = isClaimed = FTBChunksAPI.api().getManager().getChunk(new ChunkDimPos(this.level, target)) != null;
                if (isClaimed) {
                    return 1000;
                }
            }
            targetBlock.destroy((LevelAccessor)this.level, pos, targetState);
            this.level.setBlock(target, Blocks.AIR.defaultBlockState(), 34, 0);
            this.removedBlocks.add(target.immutable());
            this.borderBlocks.remove(target.immutable());
            List entityCandidates = this.level.getEntitiesOfClass(LivingEntity.class, new AABB(pos.subtract(new Vec3i(radius, radius, radius)).getCenter(), pos.offset(new Vec3i(radius, radius, radius)).getCenter()), EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(EntitySelector.NO_CREATIVE_OR_SPECTATOR));
            entityCandidates.forEach(entity -> {
                double entityDist = entity.distanceToSqr(pos.getCenter());
                double distPercentage = entityDist / (double)radiusSq;
                double damage = (double)radiusSq / distPercentage;
                System.out.println(entityDist + ":" + damage);
                entity.hurt(new DamageSource((Holder)this.level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.EXPLOSION)), (float)damage);
            });
        }
        return usedPower;
    }

    private List<Vec3> getRandomRayDirections(int count) {
        ArrayList<Vec3> rayDirections = new ArrayList<Vec3>(count);
        double angleIncrement = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double baseAngle = (double)i * angleIncrement;
            double randomPerturbation = ((double)this.level.random.nextFloat() - 0.5) * (angleIncrement / 2.0);
            double angle = baseAngle + randomPerturbation;
            double x = Math.cos(angle);
            double z = Math.sin(angle);
            rayDirections.add(new Vec3(x, 0.0, z));
        }
        return rayDirections;
    }

    private Vec3 addRandomOffset(Vec3 direction, float amount) {
        return direction.add((double)(this.level.random.nextFloat() * amount - amount / 2.0f), (double)(this.level.random.nextFloat() * amount - amount / 2.0f), (double)(this.level.random.nextFloat() * amount - amount / 2.0f));
    }

    private class DirectionExplosionWave {
        private final Vec3 direction;
        private int lastRadius;
        private BlockPos lastPosition;
        private int lastRadiusReduction;

        private DirectionExplosionWave(int initialRadius, Vec3 direction, BlockPos pos) {
            this.direction = direction;
            this.lastRadius = initialRadius;
            this.lastPosition = pos;
            this.lastRadiusReduction = 1;
        }

        private void nextGeneration() {
            boolean isLastGeneration;
            int expectedPower;
            int currentRadius = this.lastRadius - this.lastRadiusReduction;
            if (currentRadius <= 1) {
                return;
            }
            Vec3 rayOffset = this.direction.scale((double)currentRadius);
            BlockPos target = this.lastPosition.offset((Vec3i)BlockPos.containing((Position)rayOffset));
            int power = currentRadius * 3;
            this.lastRadius = currentRadius;
            this.lastPosition = target;
            int usedPower = NuclearExplosionEntity.this.explosionSphere(currentRadius, power, target);
            if (usedPower > (expectedPower = currentRadius * currentRadius * currentRadius * 3)) {
                this.lastRadiusReduction = 2;
            }
            boolean bl = isLastGeneration = currentRadius - this.lastRadiusReduction <= 1;
            if (isLastGeneration) {
                NuclearExplosionEntity.this.collectExtraEdgeBlocks(target.offset((Vec3i)BlockPos.containing((Position)rayOffset.scale(3.0))));
            }
        }
    }
}

